/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.tuple;

import net.sf.staccatocommons.lang.tuple.Tuple;
import net.sf.staccatocommons.lang.value.RelevantState;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class Quadruple<T1, T2, T3, T4>
extends Tuple
implements Comparable<Quadruple<T1, T2, T3, T4>>,
Tuple.FirstAware<T1>,
Tuple.SecondAware<T2>,
Tuple.ThirdAware<T3>,
Tuple.FourthAware<T4> {
    private static final long serialVersionUID = -1072243152313731077L;
    private static final RelevantState<Quadruple> VAL = new Tuple.TupleState<Quadruple>(4){

        @Override
        protected void collectState(Quadruple o, RelevantState.StateCollector b) {
            b.add(o.first).add(o.second).add(o.third).add(o.fourth);
        }
    };
    private final T1 first;
    private final T2 second;
    private final T3 third;
    private final T4 fourth;

    public Quadruple(T1 first, T2 second, T3 third, T4 fourth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    @Override
    public T1 first() {
        return this.first;
    }

    @Override
    public T2 second() {
        return this.second;
    }

    @Override
    public T3 third() {
        return this.third;
    }

    @Override
    public T4 fourth() {
        return this.fourth;
    }

    @Override
    public T1 _0() {
        return this.first();
    }

    @Override
    public T2 _1() {
        return this.second();
    }

    @Override
    public T3 _2() {
        return this.third();
    }

    @Override
    public T4 _3() {
        return this.fourth();
    }

    public String toString() {
        return VAL.toString(this);
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return new Object[]{this.first, this.second, this.third, this.fourth};
    }

    @Override
    public int compareTo(Quadruple<T1, T2, T3, T4> other) {
        return VAL.compareTo(this, other);
    }

    public int hashCode() {
        return VAL.hashCode(this);
    }

    public boolean equals(Object obj) {
        return VAL.equals(this, obj);
    }
}

