
package org.mule.modules.coupa.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.modules.coupa.config.FindMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FindDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public FindDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(FindMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if (element.hasAttribute("type")) {
            builder.addPropertyValue("type", element.getAttribute("type"));
        }
        Element conditionsListElement = null;
        conditionsListElement = DomUtils.getChildElementByTagName(element, "conditions");
        List<Element> conditionsListChilds = null;
        if (conditionsListElement!= null) {
            String conditionsRef = conditionsListElement.getAttribute("ref");
            if ((conditionsRef!= null)&&(!StringUtils.isBlank(conditionsRef))) {
                if ((!conditionsRef.startsWith(patternInfo.getPrefix()))&&(!conditionsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("conditions", new RuntimeBeanReference(conditionsRef));
                } else {
                    builder.addPropertyValue("conditions", conditionsRef);
                }
            } else {
                ManagedMap conditions = new ManagedMap();
                conditionsListChilds = DomUtils.getChildElementsByTagName(conditionsListElement, "condition");
                if (conditionsListChilds!= null) {
                    if (conditionsListChilds.size() == 0) {
                        conditionsListChilds = DomUtils.getChildElements(conditionsListElement);
                    }
                    for (Element conditionsChild: conditionsListChilds) {
                        String conditionsValueRef = conditionsChild.getAttribute("value-ref");
                        String conditionsKeyRef = conditionsChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((conditionsValueRef!= null)&&(!StringUtils.isBlank(conditionsValueRef))) {
                            valueObject = new RuntimeBeanReference(conditionsValueRef);
                        } else {
                            valueObject = conditionsChild.getTextContent();
                        }
                        if ((conditionsKeyRef!= null)&&(!StringUtils.isBlank(conditionsKeyRef))) {
                            keyObject = new RuntimeBeanReference(conditionsKeyRef);
                        } else {
                            keyObject = conditionsChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = conditionsChild.getTagName();
                        }
                        conditions.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("conditions", conditions);
            }
        }
        if ((element.getAttribute("exactMatch")!= null)&&(!StringUtils.isBlank(element.getAttribute("exactMatch")))) {
            builder.addPropertyValue("exactMatch", element.getAttribute("exactMatch"));
        }
        if ((element.getAttribute("offset")!= null)&&(!StringUtils.isBlank(element.getAttribute("offset")))) {
            builder.addPropertyValue("offset", element.getAttribute("offset"));
        }
        if ((element.getAttribute("limit")!= null)&&(!StringUtils.isBlank(element.getAttribute("limit")))) {
            builder.addPropertyValue("limit", element.getAttribute("limit"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
