
package org.mule.modules.coupa.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.modules.coupa.config.SaveMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SaveDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public SaveDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(SaveMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if (element.hasAttribute("type")) {
            builder.addPropertyValue("type", element.getAttribute("type"));
        }
        Element resourceListElement = null;
        resourceListElement = DomUtils.getChildElementByTagName(element, "resource");
        List<Element> resourceListChilds = null;
        if (resourceListElement!= null) {
            String resourceRef = resourceListElement.getAttribute("ref");
            if ((resourceRef!= null)&&(!StringUtils.isBlank(resourceRef))) {
                if ((!resourceRef.startsWith(patternInfo.getPrefix()))&&(!resourceRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("resource", new RuntimeBeanReference(resourceRef));
                } else {
                    builder.addPropertyValue("resource", resourceRef);
                }
            } else {
                ManagedMap resource = new ManagedMap();
                resourceListChilds = DomUtils.getChildElementsByTagName(resourceListElement, "resource");
                if (resourceListChilds!= null) {
                    if (resourceListChilds.size() == 0) {
                        resourceListChilds = DomUtils.getChildElements(resourceListElement);
                    }
                    for (Element resourceChild: resourceListChilds) {
                        String resourceValueRef = resourceChild.getAttribute("value-ref");
                        String resourceKeyRef = resourceChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((resourceValueRef!= null)&&(!StringUtils.isBlank(resourceValueRef))) {
                            valueObject = new RuntimeBeanReference(resourceValueRef);
                        } else {
                            valueObject = resourceChild.getTextContent();
                        }
                        if ((resourceKeyRef!= null)&&(!StringUtils.isBlank(resourceKeyRef))) {
                            keyObject = new RuntimeBeanReference(resourceKeyRef);
                        } else {
                            keyObject = resourceChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = resourceChild.getTagName();
                        }
                        resource.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("resource", resource);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
