/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.util.Collections;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.util.StringUtils;

public class MuleModule {
    private final String name;
    private final Set<String> exportedPackages;
    private final Set<String> exportedPaths;

    public MuleModule(String name, Set<String> exportedPackages, Set<String> exportedPaths) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)name) ? 1 : 0) != 0, (String)"Name cannot be empty");
        Preconditions.checkArgument((exportedPackages != null ? 1 : 0) != 0, (String)"ExportedPackages cannot be null");
        Preconditions.checkArgument((exportedPaths != null ? 1 : 0) != 0, (String)"ExportedPaths cannot be null");
        this.name = name;
        this.exportedPackages = Collections.unmodifiableSet(exportedPackages);
        this.exportedPaths = Collections.unmodifiableSet(exportedPaths);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    public Set<String> getExportedPaths() {
        return this.exportedPaths;
    }
}

