/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.container.internal.ContainerClassLoaderFilterFactory;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.FilteringContainerClassLoader;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.container.internal.MuleModule;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupStrategy;
import org.mule.runtime.module.artifact.classloader.EnumerationAdapter;
import org.mule.runtime.module.artifact.classloader.FilteringArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.MuleClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;

public class ContainerClassLoaderFactory {
    public static final Set<String> SYSTEM_PACKAGES = ImmutableSet.of((Object)"org.mule.runtime", (Object)"com.mulesoft.mule.runtime");
    public static final Set<String> BOOT_PACKAGES = ImmutableSet.of((Object)"java", (Object)"javax.smartcardio", (Object)"javax.resource", (Object)"javax.servlet", (Object)"javax.ws", (Object)"javax.mail", (Object[])new String[]{"javax.inject", "org.apache.xerces", "org.apache.logging.log4j", "org.slf4j", "org.apache.commons.logging", "org.apache.log4j", "org.dom4j", "com.sun", "sun", "org.mule.mvel2", "org.codehaus.groovy", "org.aopalliance.aop"});
    private ModuleDiscoverer moduleDiscoverer = new ContainerModuleDiscoverer(this.getClass().getClassLoader());

    public ArtifactClassLoader createContainerClassLoader(ClassLoader parentClassLoader) {
        List<MuleModule> muleModules = this.moduleDiscoverer.discover();
        ClassLoaderLookupPolicy containerLookupPolicy = this.getContainerClassLoaderLookupPolicy(muleModules);
        return this.createArtifactClassLoader(parentClassLoader, muleModules, containerLookupPolicy, new ArtifactDescriptor("mule"));
    }

    protected ClassLoaderLookupPolicy getContainerClassLoaderLookupPolicy(List<MuleModule> muleModules) {
        HashSet<String> parentOnlyPackages = new HashSet<String>(this.getBootPackages());
        parentOnlyPackages.addAll(SYSTEM_PACKAGES);
        Map<String, ClassLoaderLookupStrategy> lookupStrategies = this.buildClassLoaderLookupStrategy(muleModules);
        return new MuleClassLoaderLookupPolicy(lookupStrategies, parentOnlyPackages);
    }

    protected ArtifactClassLoader createArtifactClassLoader(ClassLoader parentClassLoader, List<MuleModule> muleModules, ClassLoaderLookupPolicy containerLookupPolicy, ArtifactDescriptor artifactDescriptor) {
        return this.createContainerFilteringClassLoader(muleModules, (ArtifactClassLoader)new MuleContainerClassLoader(artifactDescriptor, new URL[0], parentClassLoader, containerLookupPolicy));
    }

    public void setModuleDiscoverer(ModuleDiscoverer moduleDiscoverer) {
        this.moduleDiscoverer = moduleDiscoverer;
    }

    private Map<String, ClassLoaderLookupStrategy> buildClassLoaderLookupStrategy(List<MuleModule> muleModules) {
        HashMap<String, ClassLoaderLookupStrategy> result = new HashMap<String, ClassLoaderLookupStrategy>();
        for (MuleModule muleModule : muleModules) {
            for (String exportedPackage : muleModule.getExportedPackages()) {
                result.put(exportedPackage, this.getLookupStrategyFor(exportedPackage));
            }
        }
        return result;
    }

    private ClassLoaderLookupStrategy getLookupStrategyFor(String exportedPackage) {
        return exportedPackage.startsWith("javax.") ? ClassLoaderLookupStrategy.PARENT_FIRST : ClassLoaderLookupStrategy.PARENT_ONLY;
    }

    protected FilteringArtifactClassLoader createContainerFilteringClassLoader(List<MuleModule> muleModules, ArtifactClassLoader containerClassLoader) {
        return new FilteringContainerClassLoader(containerClassLoader, new ContainerClassLoaderFilterFactory().create(this.getBootPackages(), muleModules));
    }

    protected Set<String> getBootPackages() {
        return BOOT_PACKAGES;
    }

    private static final class MuleContainerClassLoader
    extends MuleArtifactClassLoader {
        private MuleContainerClassLoader(ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
            super("container", artifactDescriptor, urls, parent, lookupPolicy);
        }

        public URL findResource(String name) {
            return null;
        }

        public Enumeration<URL> findResources(String name) throws IOException {
            return new EnumerationAdapter(Collections.emptyList());
        }

        static {
            MuleContainerClassLoader.registerAsParallelCapable();
        }
    }
}

