/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.container.internal.MuleModule;
import org.mule.runtime.core.util.PropertiesUtils;

public class ClasspathModuleDiscoverer
implements ModuleDiscoverer {
    public static final String MODULE_PROPERTIES = "META-INF/mule-module.properties";
    private final ClassLoader classLoader;

    public ClasspathModuleDiscoverer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public List<MuleModule> discover() {
        LinkedList<MuleModule> modules = new LinkedList<MuleModule>();
        HashSet<String> moduleNames = new HashSet<String>();
        try {
            for (Properties moduleProperties : PropertiesUtils.discoverProperties((ClassLoader)this.classLoader, (String)MODULE_PROPERTIES)) {
                MuleModule module = this.createModule(moduleProperties);
                if (moduleNames.contains(module.getName())) {
                    throw new IllegalStateException(String.format("Module '%s' was already defined", module.getName()));
                }
                moduleNames.add(module.getName());
                modules.add(module);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot discover mule modules", e);
        }
        return modules;
    }

    private MuleModule createModule(Properties moduleProperties) {
        String exportedResourcesProperty;
        String moduleName = (String)moduleProperties.get("module.name");
        if (StringUtils.isEmpty((String)moduleName)) {
            throw new IllegalStateException("Mule-module.properties must contain module.name property");
        }
        HashSet<String> modulePackages = new HashSet<String>();
        HashSet<String> modulePaths = new HashSet<String>();
        String exportedPackagesProperty = (String)moduleProperties.get("artifact.export.classPackages");
        if (!StringUtils.isEmpty((String)exportedPackagesProperty)) {
            for (String packageName : exportedPackagesProperty.split(",")) {
                if (StringUtils.isEmpty((String)(packageName = packageName.trim()))) continue;
                modulePackages.add(packageName);
            }
        }
        if (!StringUtils.isEmpty((String)(exportedResourcesProperty = (String)moduleProperties.get("artifact.export.resources")))) {
            for (String path : exportedResourcesProperty.split(",")) {
                if (StringUtils.isEmpty((String)path.trim())) continue;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                modulePaths.add(path);
            }
        }
        return new MuleModule(moduleName, modulePackages, modulePaths);
    }
}

