/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.api;

import java.io.File;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.util.StringUtils;

public class MuleFoldersUtil {
    public static final String EXECUTION_FOLDER = ".mule";
    public static final String LIB_FOLDER = "lib";
    public static final String APPS_FOLDER = "apps";
    public static final String PLUGINS_FOLDER = "plugins";
    public static final String CLASSES_FOLDER = "classes";
    public static final String DOMAINS_FOLDER = "domains";
    public static final String CONTAINER_APP_PLUGINS = "plugins";
    public static final String USER_FOLDER = "user";
    public static final String SERVICES_FOLDER = "services";

    private MuleFoldersUtil() {
    }

    public static File getMuleHomeFolder() {
        String muleHome = System.getProperty("mule.home", ".");
        return new File(muleHome);
    }

    public static File getServicesFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), SERVICES_FOLDER);
    }

    public static File getServiceFolder(String name) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)name) ? 1 : 0) != 0, (String)"name cannot be empty");
        return new File(MuleFoldersUtil.getServicesFolder(), name);
    }

    public static File getDomainsFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), DOMAINS_FOLDER);
    }

    public static File getDomainFolder(String domainName) {
        return new File(MuleFoldersUtil.getDomainsFolder(), domainName);
    }

    public static File getDomainLibFolder(String domainName) {
        return new File(MuleFoldersUtil.getDomainFolder(domainName), LIB_FOLDER);
    }

    public static File getAppsFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), APPS_FOLDER);
    }

    public static File getAppFolder(String appName) {
        return new File(MuleFoldersUtil.getAppsFolder(), appName);
    }

    public static File getAppClassesFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), CLASSES_FOLDER);
    }

    public static File getAppLibFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), LIB_FOLDER);
    }

    public static File getAppPluginsFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), "plugins");
    }

    public static File getAppSharedPluginLibsFolder(String appName) {
        return new File(MuleFoldersUtil.getAppPluginsFolder(appName), LIB_FOLDER);
    }

    public static File getExecutionFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), EXECUTION_FOLDER);
    }

    public static File getMuleLibFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), LIB_FOLDER);
    }

    public static File getUserLibFolder() {
        return new File(MuleFoldersUtil.getMuleLibFolder(), USER_FOLDER);
    }

    public static File getAppTempFolder(String appName) {
        return new File(MuleFoldersUtil.getExecutionFolder(), appName);
    }

    public static File getContainerAppPluginsFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), "plugins");
    }

    public static File getServicesTempFolder() {
        return new File(MuleFoldersUtil.getExecutionFolder(), SERVICES_FOLDER);
    }
}

