/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cmis.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.mule.modules.cmis.exception.CMISConnectorConnectionException;
import org.mule.modules.cmis.exception.CMISConnectorException;
import org.mule.modules.cmis.runtime.CMISFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMISFacadeAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(CMISFacadeAdaptor.class);

    private CMISFacadeAdaptor() {
    }

    public static CMISFacade adapt(CMISFacade facade) {
        return (CMISFacade)Proxy.newProxyInstance(CMISFacadeAdaptor.class.getClassLoader(), new Class[]{CMISFacade.class}, (InvocationHandler)new MyInvocationHandler(facade));
    }

    private static class MyInvocationHandler
    implements InvocationHandler {
        private final CMISFacade facade;

        private MyInvocationHandler(CMISFacade facade) {
            this.facade = facade;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (logger.isDebugEnabled()) {
                logger.debug("Invoked method {0} with arguments {1}", (Object)method.getName(), (Object)args);
            }
            try {
                Object ret = method.invoke((Object)this.facade, args);
                if (logger.isDebugEnabled()) {
                    logger.debug("Returned method {0} with value {1}", ret);
                }
                return ret;
            }
            catch (InvocationTargetException e) {
                Throwable cause;
                if (logger.isWarnEnabled()) {
                    logger.warn("Method " + method.getName() + " thew " + e.getClass(), (Throwable)e);
                }
                if ((cause = e.getCause()) instanceof CmisConnectionException) {
                    throw new CMISConnectorConnectionException(cause);
                }
                if (cause instanceof CMISConnectorConnectionException || cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new CMISConnectorException(cause);
            }
        }
    }
}

