
package org.mule.module.cmis.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.cmis.config.ApplyPolicyMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ApplyPolicyDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public ApplyPolicyDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ApplyPolicyMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("cmisObject-ref")!= null)&&(!StringUtils.isBlank(element.getAttribute("cmisObject-ref")))) {
            if (element.getAttribute("cmisObject-ref").startsWith("#")) {
                builder.addPropertyValue("cmisObject", element.getAttribute("cmisObject-ref"));
            } else {
                builder.addPropertyValue("cmisObject", (("#[registry:"+ element.getAttribute("cmisObject-ref"))+"]"));
            }
        }
        if ((element.getAttribute("objectId")!= null)&&(!StringUtils.isBlank(element.getAttribute("objectId")))) {
            builder.addPropertyValue("objectId", element.getAttribute("objectId"));
        }
        Element policyIdsListElement = null;
        policyIdsListElement = DomUtils.getChildElementByTagName(element, "policy-ids");
        List<Element> policyIdsListChilds = null;
        if (policyIdsListElement!= null) {
            String policyIdsRef = policyIdsListElement.getAttribute("ref");
            if ((policyIdsRef!= null)&&(!StringUtils.isBlank(policyIdsRef))) {
                if ((!policyIdsRef.startsWith(patternInfo.getPrefix()))&&(!policyIdsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("policyIds", new RuntimeBeanReference(policyIdsRef));
                } else {
                    builder.addPropertyValue("policyIds", policyIdsRef);
                }
            } else {
                ManagedList policyIds = new ManagedList();
                policyIdsListChilds = DomUtils.getChildElementsByTagName(policyIdsListElement, "policy-id");
                if (policyIdsListChilds!= null) {
                    for (Element policyIdsChild: policyIdsListChilds) {
                        String valueRef = policyIdsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            policyIds.add(new RuntimeBeanReference(valueRef));
                        } else {
                            policyIds.add(policyIdsChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("policyIds", policyIds);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
