/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.client;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.RequestContext;
import org.mule.api.FutureMessageResult;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.security.Credentials;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageAdapter;
import org.mule.module.client.i18n.ClientMessages;
import org.mule.module.client.remoting.RemoteDispatcherException;
import org.mule.module.client.remoting.ServerHandshake;
import org.mule.module.client.remoting.UnsupportedWireFormatException;
import org.mule.module.client.remoting.notification.RemoteDispatcherNotification;
import org.mule.security.MuleCredentials;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;

public class RemoteDispatcher
implements Disposable {
    protected static final Log logger = LogFactory.getLog(RemoteDispatcher.class);
    private OutboundEndpoint asyncServerEndpoint;
    private OutboundEndpoint syncServerEndpoint;
    private Credentials credentials = null;
    private MuleContext muleContext;
    private Executor asyncExecutor;
    private WireFormat wireFormat;

    protected RemoteDispatcher(String endpoint, Credentials credentials, MuleContext muleContext) throws MuleException {
        this(endpoint, muleContext);
        this.credentials = credentials;
    }

    protected RemoteDispatcher(String endpoint, MuleContext muleContext) throws MuleException {
        this.muleContext = muleContext;
        EndpointFactory endpointFactory = muleContext.getRegistry().lookupEndpointFactory();
        this.asyncServerEndpoint = endpointFactory.getOutboundEndpoint(endpoint);
        EndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(endpoint);
        endpointBuilder.setSynchronous(true);
        this.syncServerEndpoint = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointBuilder);
        this.wireFormat = this.requestWireFormat();
    }

    protected WireFormat requestWireFormat() throws MuleException {
        ServerHandshake handshake;
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"MULE_CLIENT_HANDSHAKE", this.muleContext);
        MuleMessage result = this.syncServerEndpoint.send((MuleEvent)new DefaultMuleEvent((MuleMessage)msg, (ImmutableEndpoint)this.syncServerEndpoint, (MuleSession)new DefaultMuleSession(this.muleContext), true));
        if (result == null) {
            throw new RemoteDispatcherException(ClientMessages.failedToDispatchActionNoResponseFromServer("request wire format", 5000));
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(result.getPayloadAsBytes());
            handshake = (ServerHandshake)SerializationUtils.deserialize((InputStream)in);
        }
        catch (Exception e) {
            throw new RemoteDispatcherException(ClientMessages.failedToDeserializeHandshakeFromServer(), e);
        }
        try {
            WireFormat wf = (WireFormat)ClassUtils.instanciateClass((String)handshake.getWireFormatClass(), (Object[])ClassUtils.NO_ARGS, this.getClass());
            wf.setMuleContext(this.muleContext);
            return wf;
        }
        catch (Exception e) {
            throw new UnsupportedWireFormatException(handshake.getWireFormatClass(), e);
        }
    }

    protected void setExecutor(Executor e) {
        this.asyncExecutor = e;
    }

    public void dispatchToRemoteComponent(String component, Object payload, Map messageProperties) throws MuleException {
        this.doToRemoteComponent(component, payload, messageProperties, false);
    }

    public MuleMessage sendToRemoteComponent(String component, Object payload, Map messageProperties) throws MuleException {
        return this.doToRemoteComponent(component, payload, messageProperties, true);
    }

    public FutureMessageResult sendAsyncToRemoteComponent(final String component, String transformers, final Object payload, final Map messageProperties) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.doToRemoteComponent(component, payload, messageProperties, true);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable, this.muleContext);
        if (this.asyncExecutor != null) {
            result.setExecutor(this.asyncExecutor);
        }
        if (transformers != null) {
            result.setTransformers(TransformerUtils.getTransformers((String)transformers, (MuleContext)this.muleContext));
        }
        result.execute();
        return result;
    }

    public MuleMessage sendRemote(String endpoint, Object payload, Map messageProperties, int timeout) throws MuleException {
        return this.doToRemote(endpoint, payload, messageProperties, true, timeout);
    }

    public MuleMessage sendRemote(String endpoint, Object payload, Map messageProperties) throws MuleException {
        return this.doToRemote(endpoint, payload, messageProperties, true, this.muleContext.getConfiguration().getDefaultResponseTimeout());
    }

    public void dispatchRemote(String endpoint, Object payload, Map messageProperties) throws MuleException {
        this.doToRemote(endpoint, payload, messageProperties, false, -1);
    }

    public FutureMessageResult sendAsyncRemote(final String endpoint, final Object payload, final Map messageProperties) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.doToRemote(endpoint, payload, messageProperties, true, -1);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable, this.muleContext);
        if (this.asyncExecutor != null) {
            result.setExecutor(this.asyncExecutor);
        }
        result.execute();
        return result;
    }

    public MuleMessage receiveRemote(String endpoint, int timeout) throws MuleException {
        RemoteDispatcherNotification action = new RemoteDispatcherNotification(null, 601, endpoint);
        action.setProperty("MULE_REMOTE_SYNC", "true");
        if (timeout != Integer.MIN_VALUE) {
            action.setProperty("MULE_EVENT_TIMEOUT", new Long(timeout));
        }
        return this.dispatchAction(action, true, timeout);
    }

    public FutureMessageResult asyncReceiveRemote(final String endpoint, final int timeout) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.receiveRemote(endpoint, timeout);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable, this.muleContext);
        if (this.asyncExecutor != null) {
            result.setExecutor(this.asyncExecutor);
        }
        result.execute();
        return result;
    }

    protected MuleMessage doToRemoteComponent(String component, Object payload, Map messageProperties, boolean synchronous) throws MuleException {
        DefaultMuleMessage message = new DefaultMuleMessage(payload, messageProperties, this.muleContext);
        message.setBooleanProperty("MULE_REMOTE_SYNC", synchronous);
        this.setCredentials((MuleMessage)message);
        RemoteDispatcherNotification action = new RemoteDispatcherNotification((MuleMessage)message, 604, "mule://" + component);
        return this.dispatchAction(action, synchronous, this.muleContext.getConfiguration().getDefaultResponseTimeout());
    }

    protected MuleMessage doToRemote(String endpoint, Object payload, Map messageProperties, boolean synchronous, int timeout) throws MuleException {
        DefaultMuleMessage message = new DefaultMuleMessage(payload, messageProperties, this.muleContext);
        message.setProperty("MULE_REMOTE_SYNC", (Object)String.valueOf(synchronous));
        this.setCredentials((MuleMessage)message);
        RemoteDispatcherNotification action = new RemoteDispatcherNotification((MuleMessage)message, synchronous ? 603 : 602, endpoint);
        return this.dispatchAction(action, synchronous, timeout);
    }

    protected MuleMessage dispatchAction(RemoteDispatcherNotification action, boolean synchronous, int timeout) throws MuleException {
        MuleMessage result;
        OutboundEndpoint serverEndpoint = synchronous ? this.syncServerEndpoint : this.asyncServerEndpoint;
        DefaultMuleMessage serializeMessage = new DefaultMuleMessage((Object)action, this.muleContext);
        this.updateContext((MuleMessage)serializeMessage, (ImmutableEndpoint)serverEndpoint, synchronous);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.wireFormat.write((OutputStream)out, (Object)serializeMessage, serverEndpoint.getEncoding());
        byte[] payload = out.toByteArray();
        MuleMessage message = action.getMessage();
        message = message == null ? new DefaultMuleMessage((Object)payload, this.muleContext) : new DefaultMuleMessage((Object)payload, (MessageAdapter)message, this.muleContext);
        message.addProperties(action.getProperties());
        DefaultMuleSession session = new DefaultMuleSession(this.muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent(message, (ImmutableEndpoint)serverEndpoint, (MuleSession)session, true);
        event.setTimeout(timeout);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleClient sending remote call to: " + action.getResourceIdentifier() + ". At " + serverEndpoint.toString() + " . Event is: " + event));
        }
        try {
            if (!synchronous) {
                serverEndpoint.dispatch((MuleEvent)event);
                return null;
            }
            result = serverEndpoint.send((MuleEvent)event);
            if (result != null && result.getPayload() != null) {
                Object response;
                if (result.getPayload() instanceof NullPayload) {
                    return null;
                }
                if (result.getPayload() instanceof InputStream) {
                    byte[] b = IOUtils.toByteArray((InputStream)((InputStream)result.getPayload()));
                    if (b.length == 0) {
                        return null;
                    }
                    ByteArrayInputStream in = new ByteArrayInputStream(b);
                    response = this.wireFormat.read((InputStream)in);
                } else {
                    ByteArrayInputStream in = new ByteArrayInputStream(result.getPayloadAsBytes());
                    response = this.wireFormat.read((InputStream)in);
                }
                if (response instanceof RemoteDispatcherNotification) {
                    response = ((RemoteDispatcherNotification)((Object)response)).getMessage();
                }
                return (MuleMessage)response;
            }
        }
        catch (Exception e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result of MuleClient remote call is: " + (result == null ? "null" : result.getPayload())));
        }
        return result;
    }

    public void dispose() {
    }

    protected void setCredentials(MuleMessage message) {
        if (this.credentials != null) {
            message.setProperty("MULE_USER", (Object)MuleCredentials.createHeader((String)this.credentials.getUsername(), (char[])this.credentials.getPassword()));
        }
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    protected void updateContext(MuleMessage message, ImmutableEndpoint endpoint, boolean synchronous) throws MuleException {
        RequestContext.setEvent((MuleEvent)new DefaultMuleEvent(message, endpoint, (MuleSession)new DefaultMuleSession(this.muleContext), synchronous));
    }
}

