/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.client;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.MuleConfiguration;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.extras.client.RemoteDispatcher;
import org.mule.extras.client.i18n.ClientMessages;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.endpoint.EndpointURIEndpointBuilder;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.registry.TransientRegistry;
import org.mule.impl.security.MuleCredentials;
import org.mule.providers.AbstractConnector;
import org.mule.registry.RegistrationException;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.FutureMessageResult;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointBuilder;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;
import org.mule.umo.provider.UMOStreamMessageAdapter;
import org.mule.umo.security.UMOCredentials;
import org.mule.util.MuleObjectHelper;
import org.mule.util.StringUtils;

public class MuleClient
implements Disposable {
    protected static final Log logger = LogFactory.getLog((Class)MuleClient.class);
    private UMOManagementContext managementContext;
    private Executor asyncExecutor = null;
    private List dispatchers = new ArrayList();
    private MuleCredentials user;

    public MuleClient() throws UMOException {
        this.init(true);
    }

    public MuleClient(UMOManagementContext context) throws UMOException {
        this.managementContext = context;
        this.init(false);
    }

    public MuleClient(String configResources) throws UMOException {
        this(configResources, (ConfigurationBuilder)new MuleXmlConfigurationBuilder());
    }

    public MuleClient(String user, String password) throws UMOException {
        this.init(true);
        this.user = new MuleCredentials(user, password.toCharArray());
    }

    public MuleClient(String configResources, ConfigurationBuilder builder) throws ConfigurationException {
        if (builder == null) {
            logger.info((Object)("Builder passed in was null, using default builder: " + MuleXmlConfigurationBuilder.class.getName()));
            builder = new MuleXmlConfigurationBuilder();
        }
        this.managementContext = builder.configure(configResources, null);
    }

    public MuleClient(String configResources, ConfigurationBuilder builder, String user, String password) throws ConfigurationException {
        this(configResources, builder);
        this.user = new MuleCredentials(user, password.toCharArray());
    }

    private void init(boolean startManager) throws UMOException {
        if (this.managementContext != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"There is already a managementContext locally available to this client, no need to create a new one");
            }
        } else if (MuleServer.getManagementContext() != null) {
            this.managementContext = MuleServer.getManagementContext();
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"There is no managementContext instance locally available for this client, creating a new Manager");
            }
            TransientRegistry registry = TransientRegistry.createNew();
            this.managementContext = MuleServer.getManagementContext();
        }
        this.asyncExecutor = this.managementContext.getWorkManager();
        if (!this.managementContext.isStarted() && startManager) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Starting Mule Manager for this client");
            }
            this.managementContext.start();
        }
    }

    public void dispatch(String url, Object payload, Map messageProperties) throws UMOException {
        this.dispatch(url, (UMOMessage)new MuleMessage(payload, messageProperties));
    }

    public void dispatch(String url, UMOMessage message) throws UMOException {
        UMOEvent event = this.getEvent(message, url, false, false);
        try {
            event.getSession().dispatchEvent(event);
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(ClientMessages.failedToDispatchClientEvent(), event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    public void dispatchStream(String url, UMOStreamMessageAdapter message) throws UMOException {
        UMOEvent event = this.getEvent((UMOMessage)new MuleMessage((Object)message), url, false, true);
        try {
            event.getSession().dispatchEvent(event);
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(ClientMessages.failedToDispatchClientEvent(), event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    public UMOStreamMessageAdapter sendStream(String url, UMOStreamMessageAdapter message) throws UMOException {
        return this.sendStream(url, message, Integer.MIN_VALUE);
    }

    public UMOStreamMessageAdapter sendStream(String url, UMOStreamMessageAdapter message, int timeout) throws UMOException {
        UMOEvent event = this.getEvent((UMOMessage)new MuleMessage((Object)message), url, true, true);
        event.setTimeout(timeout);
        try {
            UMOMessage result = event.getSession().sendEvent(event);
            if (result != null) {
                if (result.getAdapter() instanceof UMOStreamMessageAdapter) {
                    return (UMOStreamMessageAdapter)result.getAdapter();
                }
                throw new IllegalStateException("Mismatch of stream states. A stream was used for outbound channel, but a stream was not used for the response");
            }
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(ClientMessages.failedToDispatchClientEvent(), event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
        return null;
    }

    public UMOMessage sendDirect(String component, String transformers, Object payload, Map messageProperties) throws UMOException {
        MuleMessage message = new MuleMessage(payload, messageProperties);
        return this.sendDirect(component, transformers, (UMOMessage)message);
    }

    public UMOMessage sendDirect(String componentName, String transformers, UMOMessage message) throws UMOException {
        UMOComponent component = this.managementContext.getRegistry().lookupComponent(componentName);
        if (component == null) {
            throw new MessagingException(CoreMessages.objectNotRegistered((String)"Component", (String)componentName), message, null);
        }
        List trans = null;
        if (transformers != null) {
            trans = MuleObjectHelper.getTransformers((String)transformers, (String)",");
        }
        if (!RegistryContext.getConfiguration().isDefaultSynchronousEndpoints()) {
            logger.warn((Object)"The mule managementContext is running synchronously, a null message payload will be returned");
        }
        MuleSession session = new MuleSession(component);
        UMOImmutableEndpoint endpoint = this.getDefaultClientEndpoint(component, message.getPayload());
        MuleEvent event = new MuleEvent(message, endpoint, (UMOSession)session, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleClient sending event direct to: " + componentName + ". Event is: " + event));
        }
        UMOMessage result = event.getComponent().sendEvent((UMOEvent)event);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result of MuleClient sendDirect is: " + (result == null ? "null" : result.getPayload())));
        }
        if (result != null && trans != null) {
            return TransformerUtils.applyAllTransformers((List)trans, (UMOMessage)result);
        }
        return result;
    }

    public void dispatchDirect(String component, Object payload, Map messageProperties) throws UMOException {
        this.dispatchDirect(component, (UMOMessage)new MuleMessage(payload, messageProperties));
    }

    public void dispatchDirect(String componentName, UMOMessage message) throws UMOException {
        UMOComponent component = this.managementContext.getRegistry().lookupComponent(componentName);
        if (component == null) {
            throw new MessagingException(CoreMessages.objectNotRegistered((String)"Component", (String)componentName), message, null);
        }
        MuleSession session = new MuleSession(component);
        UMOImmutableEndpoint endpoint = this.getDefaultClientEndpoint(component, message.getPayload());
        MuleEvent event = new MuleEvent(message, endpoint, (UMOSession)session, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleClient dispatching event direct to: " + componentName + ". Event is: " + event));
        }
        event.getComponent().dispatchEvent((UMOEvent)event);
    }

    public FutureMessageResult sendAsync(String url, Object payload, Map messageProperties) throws UMOException {
        return this.sendAsync(url, payload, messageProperties, 0);
    }

    public FutureMessageResult sendAsync(String url, UMOMessage message) throws UMOException {
        return this.sendAsync(url, message, Integer.MIN_VALUE);
    }

    public FutureMessageResult sendAsync(String url, Object payload, Map messageProperties, int timeout) throws UMOException {
        return this.sendAsync(url, (UMOMessage)new MuleMessage(payload, messageProperties), timeout);
    }

    public FutureMessageResult sendAsync(final String url, final UMOMessage message, final int timeout) throws UMOException {
        Callable call = new Callable(){

            public Object call() throws Exception {
                return MuleClient.this.send(url, message, timeout);
            }
        };
        FutureMessageResult result = new FutureMessageResult(call);
        if (this.asyncExecutor != null) {
            result.setExecutor(this.asyncExecutor);
        }
        result.execute();
        return result;
    }

    public FutureMessageResult sendDirectAsync(String component, String transformers, Object payload, Map messageProperties) throws UMOException {
        return this.sendDirectAsync(component, transformers, (UMOMessage)new MuleMessage(payload, messageProperties));
    }

    public FutureMessageResult sendDirectAsync(final String component, String transformers, final UMOMessage message) throws UMOException {
        Callable call = new Callable(){

            public Object call() throws Exception {
                return MuleClient.this.sendDirect(component, null, message);
            }
        };
        FutureMessageResult result = new FutureMessageResult(call);
        if (this.asyncExecutor != null) {
            result.setExecutor(this.asyncExecutor);
        }
        if (StringUtils.isNotBlank((String)transformers)) {
            result.setTransformers(MuleObjectHelper.getTransformers((String)transformers, (String)","));
        }
        result.execute();
        return result;
    }

    public UMOMessage send(String url, Object payload, Map messageProperties) throws UMOException {
        return this.send(url, payload, messageProperties, Integer.MIN_VALUE);
    }

    public UMOMessage send(String url, UMOMessage message) throws UMOException {
        return this.send(url, message, Integer.MIN_VALUE);
    }

    public UMOMessage send(String url, Object payload, Map messageProperties, int timeout) throws UMOException {
        if (messageProperties == null) {
            messageProperties = new HashMap<String, String>();
        }
        if (messageProperties.get("MULE_REMOTE_SYNC") == null) {
            messageProperties.put("MULE_REMOTE_SYNC", "true");
        }
        MuleMessage message = new MuleMessage(payload, messageProperties);
        return this.send(url, (UMOMessage)message, timeout);
    }

    public UMOMessage send(String url, UMOMessage message, int timeout) throws UMOException {
        UMOEvent event = this.getEvent(message, url, true, false);
        event.setTimeout(timeout);
        try {
            return event.getSession().sendEvent(event);
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(ClientMessages.failedToDispatchClientEvent(), event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    public UMOMessage receive(String url, long timeout) throws UMOException {
        UMOImmutableEndpoint endpoint = this.getInboundEndpoint(url);
        try {
            UMOMessage message = endpoint.receive(timeout);
            if (message != null && endpoint.getTransformers() != null) {
                message = TransformerUtils.applyAllTransformers((List)endpoint.getTransformers(), (UMOMessage)message);
            }
            return message;
        }
        catch (Exception e) {
            throw new ReceiveException(endpoint, timeout, (Throwable)e);
        }
    }

    public UMOMessage receive(String url, String transformers, long timeout) throws UMOException {
        return this.receive(url, MuleObjectHelper.getTransformers((String)transformers, (String)","), timeout);
    }

    public UMOMessage receive(String url, List transformers, long timeout) throws UMOException {
        UMOMessage message = this.receive(url, timeout);
        if (message != null && transformers != null) {
            return TransformerUtils.applyAllTransformers((List)transformers, (UMOMessage)message);
        }
        return message;
    }

    protected UMOEvent getEvent(UMOMessage message, String uri, boolean synchronous, boolean streaming) throws UMOException {
        UMOImmutableEndpoint endpoint = this.getOutboundEndpoint(uri);
        if (!endpoint.getConnector().isStarted() && this.managementContext.isStarted()) {
            endpoint.getConnector().start();
        }
        ((UMOEndpoint)endpoint).setStreaming(streaming);
        try {
            MuleSession session = new MuleSession(message, ((AbstractConnector)endpoint.getConnector()).getSessionHandler());
            if (this.user != null) {
                message.setProperty("MULE_USER", (Object)MuleCredentials.createHeader((String)this.user.getUsername(), (char[])this.user.getPassword()));
            }
            MuleEvent event = new MuleEvent(message, endpoint, (UMOSession)session, synchronous);
            return event;
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.failedToCreate((String)"Client event"), message, endpoint, (Throwable)e);
        }
    }

    protected UMOImmutableEndpoint getInboundEndpoint(String uri) throws UMOException {
        return this.managementContext.getRegistry().lookupInboundEndpoint(uri, this.managementContext);
    }

    protected UMOImmutableEndpoint getOutboundEndpoint(String uri) throws UMOException {
        return this.managementContext.getRegistry().lookupOutboundEndpoint(uri, this.managementContext);
    }

    protected UMOImmutableEndpoint getDefaultClientEndpoint(UMOComponent component, Object payload) throws UMOException {
        UMOEndpoint endpoint = (UMOEndpoint)component.getInboundRouter().getEndpoints().get(0);
        if (endpoint != null) {
            if (endpoint.getTransformers() != null) {
                if (TransformerUtils.isSourceTypeSupportedByFirst((List)endpoint.getTransformers(), payload.getClass())) {
                    return endpoint;
                }
                EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder((UMOImmutableEndpoint)endpoint, this.managementContext);
                builder.setTransformers(new LinkedList());
                return this.managementContext.getRegistry().lookupEndpointFactory().createInboundEndpoint((UMOEndpointBuilder)builder, this.managementContext);
            }
            return endpoint;
        }
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("vm://mule.client", this.managementContext);
        builder.setName("muleClientProvider");
        endpoint = this.managementContext.getRegistry().lookupEndpointFactory().createInboundEndpoint((UMOEndpointBuilder)builder, this.managementContext);
        return endpoint;
    }

    public void sendNoReceive(String url, Object payload, Map messageProperties) throws UMOException {
        if (messageProperties == null) {
            messageProperties = new HashMap<String, String>();
        }
        messageProperties.put("MULE_REMOTE_SYNC", "false");
        MuleMessage message = new MuleMessage(payload, messageProperties);
        UMOEvent event = this.getEvent((UMOMessage)message, url, true, false);
        try {
            event.getSession().sendEvent(event);
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(ClientMessages.failedToDispatchClientEvent(), event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    public UMOManagementContext getManagementContext() {
        return this.managementContext;
    }

    public void registerComponent(Object component, String name, UMOEndpointURI listenerEndpoint) throws UMOException {
        throw new UnsupportedOperationException("registerComponent");
    }

    public void registerComponent(Object component, String name, MuleEndpointURI listenerEndpoint, MuleEndpointURI sendEndpoint) throws UMOException {
        throw new UnsupportedOperationException("registerComponent");
    }

    public void registerComponent(UMODescriptor descriptor) throws UMOException {
        throw new UnsupportedOperationException("registerComponent");
    }

    public void unregisterComponent(String name) throws UMOException {
        throw new UnsupportedOperationException("registerComponent");
    }

    public RemoteDispatcher getRemoteDispatcher(String serverEndpoint) throws UMOException {
        RemoteDispatcher rd = new RemoteDispatcher(serverEndpoint);
        rd.setExecutor(this.asyncExecutor);
        this.dispatchers.add(rd);
        return rd;
    }

    public RemoteDispatcher getRemoteDispatcher(String serverEndpoint, String user, String password) throws UMOException {
        RemoteDispatcher rd = new RemoteDispatcher(serverEndpoint, (UMOCredentials)new MuleCredentials(user, password.toCharArray()));
        rd.setExecutor(this.asyncExecutor);
        this.dispatchers.add(rd);
        return rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.dispatchers;
        synchronized (list) {
            Iterator iterator = this.dispatchers.iterator();
            while (iterator.hasNext()) {
                RemoteDispatcher remoteDispatcher = (RemoteDispatcher)iterator.next();
                remoteDispatcher.dispose();
                Object var3_3 = null;
            }
            this.dispatchers.clear();
        }
        if (RegistryContext.getConfiguration().isClientMode()) {
            this.managementContext.dispose();
        }
    }

    public void setProperty(String key, Object value) {
        try {
            this.managementContext.getRegistry().registerObject(key, value, this.managementContext);
        }
        catch (RegistrationException e) {
            logger.error((Object)e);
        }
    }

    public Object getProperty(String key) {
        return this.managementContext.getRegistry().lookupObject(key);
    }

    public MuleConfiguration getConfiguration() {
        return RegistryContext.getConfiguration();
    }
}

