/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.config.i18n.CoreMessages;

public abstract class AbstractConfigurationBuilder
implements ConfigurationBuilder {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private boolean configured = false;

    public void configure(MuleContext muleContext) throws ConfigurationException {
        try {
            this.doConfigure(muleContext);
            this.applyLifecycle(muleContext.getLifecycleManager());
            this.configured = true;
        }
        catch (Exception e) {
            this.logger.error((Object)CoreMessages.configurationBuilderError((ConfigurationBuilder)this), (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected abstract void doConfigure(MuleContext var1) throws Exception;

    protected void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
    }

    public boolean isConfigured() {
        return this.configured;
    }
}

