/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.registry.Registry;
import org.mule.config.builders.ServletContextOrClassPathResource;
import org.mule.config.spring.MuleApplicationContext;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.core.io.Resource;

public class WebappMuleXmlConfigurationBuilder
extends SpringXmlConfigurationBuilder {
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ServletContext context;

    public WebappMuleXmlConfigurationBuilder(ServletContext servletContext, String[] configResources) {
        super(configResources);
        this.context = servletContext;
    }

    public WebappMuleXmlConfigurationBuilder(ServletContext servletContext, String configResources) {
        super(configResources);
        this.context = servletContext;
    }

    protected void createSpringParentRegistry(MuleContext muleContext, Registry registry, String[] all) {
        Resource[] servletContextResources = new Resource[all.length];
        for (int i = 0; i < all.length; ++i) {
            servletContextResources[i] = new ServletContextOrClassPathResource(this.context, all[i]);
        }
        this.parentContext = this.loadParentContext(this.context);
        try {
            if (this.parentContext != null) {
                new MuleApplicationContext(muleContext, registry, servletContextResources, this.parentContext);
            } else {
                new MuleApplicationContext(muleContext, registry, servletContextResources);
            }
        }
        catch (BeansException e) {
            registry.setParent(null);
            throw e;
        }
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        ApplicationContext parentContext = null;
        String locatorFactorySelector = servletContext.getInitParameter("locatorFactorySelector");
        String parentContextKey = servletContext.getInitParameter("parentContextKey");
        if (parentContextKey != null) {
            BeanFactoryLocator locator = ContextSingletonBeanFactoryLocator.getInstance((String)locatorFactorySelector);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Getting parent context definition: using parent context key of '" + parentContextKey + "' with BeanFactoryLocator"));
            }
            parentContext = (ApplicationContext)locator.useBeanFactory(parentContextKey).getFactory();
        }
        return parentContext;
    }
}

