/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.builders.WebappMuleXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.util.StringUtils;

public class MuleXmlBuilderContextListener
implements ServletContextListener {
    public static final String INIT_PARAMETER_MULE_CONFIG = "org.mule.config";
    public static final String INIT_PARAMETER_WEBAPP_CLASSPATH = "org.mule.webapp.classpath";
    private MuleContext muleContext;
    protected final transient Log logger = LogFactory.getLog(MuleXmlBuilderContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        this.initialize(event.getServletContext());
    }

    public void initialize(ServletContext context) {
        String config = context.getInitParameter(INIT_PARAMETER_MULE_CONFIG);
        if (config == null) {
            config = this.getDefaultConfigResource();
            System.out.println("No Mule config file(s) specified, using default: " + config);
        } else {
            System.out.println("Mule config file(s): " + config);
        }
        String webappClasspath = context.getInitParameter(INIT_PARAMETER_WEBAPP_CLASSPATH);
        if (StringUtils.isBlank((String)webappClasspath)) {
            webappClasspath = null;
        }
        try {
            this.muleContext = this.createManager(config, webappClasspath, context);
            this.muleContext.start();
        }
        catch (MuleException ex) {
            context.log(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
        catch (Error error) {
            context.log(error.getMessage(), (Throwable)error);
            error.printStackTrace();
            throw error;
        }
    }

    protected MuleContext createManager(String configResource, String webappClasspath, ServletContext context) throws ConfigurationException, InitialisationException {
        WebappMuleXmlConfigurationBuilder builder = new WebappMuleXmlConfigurationBuilder(context, configResource);
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        return muleContextFactory.createMuleContext((ConfigurationBuilder)builder);
    }

    protected String getDefaultConfigResource() {
        return "mule-config.xml";
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.destroy();
    }

    public void destroy() {
        if (!(this.muleContext == null || this.muleContext.isDisposing() && this.muleContext.isDisposed())) {
            this.muleContext.dispose();
        }
    }
}

