/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.WebappMuleXmlConfigurationBuilder;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.util.StringUtils;

public class MuleXmlBuilderContextListener
implements ServletContextListener {
    public static final String INIT_PARAMETER_MULE_CONFIG = "org.mule.config";
    public static final String INIT_PARAMETER_WEBAPP_CLASSPATH = "org.mule.webapp.classpath";
    private UMOManagementContext managementContext;

    public void contextInitialized(ServletContextEvent event) {
        this.initialize(event.getServletContext());
    }

    public void initialize(ServletContext context) {
        String webappClasspath;
        String config = context.getInitParameter(INIT_PARAMETER_MULE_CONFIG);
        if (config == null) {
            config = this.getDefaultConfigResource();
        }
        if (StringUtils.isBlank((String)(webappClasspath = context.getInitParameter(INIT_PARAMETER_WEBAPP_CLASSPATH)))) {
            webappClasspath = null;
        }
        try {
            this.createManager(config, webappClasspath, context);
        }
        catch (UMOException ex) {
            context.log(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
        catch (Error error) {
            context.log(error.getMessage(), (Throwable)error);
            error.printStackTrace();
            throw error;
        }
    }

    protected UMOManagementContext createManager(String configResource, String webappClasspath, ServletContext context) throws ConfigurationException {
        WebappMuleXmlConfigurationBuilder builder = new WebappMuleXmlConfigurationBuilder(context, webappClasspath);
        this.managementContext = builder.configure(configResource, null);
        return this.managementContext;
    }

    protected String getDefaultConfigResource() {
        return "mule-config.xml";
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.destroy();
    }

    public void destroy() {
        this.managementContext.dispose();
    }
}

