/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationException;
import org.mule.config.MuleDtdResolver;
import org.mule.config.ReaderResource;
import org.mule.config.builders.MulePropertiesRuleSet;
import org.mule.config.builders.MuleSetPropertiesRule;
import org.mule.config.builders.i18n.BuildersMessages;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.container.MuleContainerContext;
import org.mule.umo.UMOFilter;
import org.mule.util.IOUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractDigesterConfiguration {
    public static final String DEFAULT_CONTAINER_CONTEXT = MuleContainerContext.class.getName();
    public static final String FILTER_INTERFACE = UMOFilter.class.getName();
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected Digester digester;
    protected List containerReferences = new ArrayList();
    protected String configEncoding;

    protected AbstractDigesterConfiguration(boolean validate, String dtd) {
        this.digester = new Digester(){

            public void warning(SAXParseException e) throws SAXException {
                if (this.errorHandler != null) {
                    this.errorHandler.warning(e);
                }
            }
        };
        this.configEncoding = System.getProperty("org.mule.encoding", MuleManager.getConfiguration().getEncoding());
        this.digester.setValidating(validate);
        this.digester.setEntityResolver((EntityResolver)new MuleDtdResolver(dtd));
        this.digester.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                AbstractDigesterConfiguration.this.logger.error((Object)exception.getMessage(), (Throwable)exception);
                throw new SAXException(exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                AbstractDigesterConfiguration.this.logger.fatal((Object)exception.getMessage(), (Throwable)exception);
                throw new SAXException(exception);
            }

            public void warning(SAXParseException exception) {
                AbstractDigesterConfiguration.this.logger.warn((Object)exception.getMessage());
            }
        });
    }

    protected Object process(ReaderResource[] configResources) throws ConfigurationException {
        Object result = null;
        for (int i = 0; i < configResources.length; ++i) {
            try {
                Reader configResource = configResources[i].getReader();
                result = this.digester.parse(configResource);
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException(BuildersMessages.failedToParseConfigResource(configResources[i].getDescription()), (Throwable)e);
            }
        }
        return result;
    }

    protected InputStream loadConfig(String configResource) throws ConfigurationException {
        InputStream is = null;
        try {
            is = IOUtils.getResourceAsStream((String)configResource, this.getClass());
        }
        catch (IOException e) {
            throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath((String)configResource), (Throwable)e);
        }
        if (is != null) {
            return is;
        }
        throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath((String)configResource));
    }

    public abstract String getRootName();

    protected void addContainerContextRules(String path, String setterMethod, int parentIndex) throws ConfigurationException {
        this.digester.addObjectCreate(path, DEFAULT_CONTAINER_CONTEXT, "className");
        this.digester.addSetProperties(path, "name", "name");
        this.addMulePropertiesRule(path, this.digester);
        this.digester.addSetNext(path, setterMethod);
    }

    protected void addServerPropertiesRules(String path, String setterMethod, int parentIndex) {
        int i = path.lastIndexOf("/");
        this.addMulePropertiesRule(path.substring(0, i), this.digester, setterMethod, path.substring(i + 1));
    }

    protected void addSetPropertiesRule(String path, Digester digester) {
        digester.addRule(path, (Rule)new MuleSetPropertiesRule());
    }

    protected void addSetPropertiesRule(String path, Digester digester, String[] s1, String[] s2) {
        digester.addRule(path, (Rule)new MuleSetPropertiesRule(s1, s2));
    }

    protected void addMulePropertiesRule(String path, Digester digester) {
        digester.addRuleSet((RuleSet)new MulePropertiesRuleSet(path, this.containerReferences));
    }

    protected void addMulePropertiesRule(String path, Digester digester, String propertiesSetter) {
        digester.addRuleSet((RuleSet)new MulePropertiesRuleSet(path, propertiesSetter, this.containerReferences));
    }

    protected void addMulePropertiesRule(String path, Digester digester, String propertiesSetter, String parentElement) {
        digester.addRuleSet((RuleSet)new MulePropertiesRuleSet(path, propertiesSetter, this.containerReferences, parentElement));
    }

    protected void addFilterRules(Digester digester, String path) throws ConfigurationException {
        this.addSingleFilterRule(digester, path);
        path = path + "/filter";
        this.addFilterGroupRule(digester, path);
        this.addFilterGroupRule(digester, path + "/left-filter");
        this.addFilterGroupRule(digester, path + "/right-filter");
        this.addFilterGroupRule(digester, path + "/filter");
        this.addFilterGroupRule(digester, path + "/left-filter/left-filter");
        this.addFilterGroupRule(digester, path + "/left-filter/right-filter");
        this.addFilterGroupRule(digester, path + "/left-filter/filter");
        this.addFilterGroupRule(digester, path + "/right-filter/left-filter");
        this.addFilterGroupRule(digester, path + "/right-filter/right-filter");
        this.addFilterGroupRule(digester, path + "/right-filter/filter");
        this.addFilterGroupRule(digester, path + "/filter/left-filter");
        this.addFilterGroupRule(digester, path + "/filter/right-filter");
        this.addFilterGroupRule(digester, path + "/filter/filter");
    }

    protected void addFilterGroupRule(Digester digester, String path) throws ConfigurationException {
        this.addLeftFilterRule(digester, path);
        this.addRightFilterRule(digester, path);
        this.addSingleFilterRule(digester, path);
    }

    protected void addLeftFilterRule(Digester digester, String path) throws ConfigurationException {
        path = path + "/left-filter";
        digester.addObjectCreate(path, FILTER_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetNext(path, "setLeftFilter");
    }

    protected void addRightFilterRule(Digester digester, String path) throws ConfigurationException {
        path = path + "/right-filter";
        digester.addObjectCreate(path, FILTER_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetNext(path, "setRightFilter");
    }

    protected void addSingleFilterRule(Digester digester, String path) throws ConfigurationException {
        path = path + "/filter";
        digester.addObjectCreate(path, FILTER_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetNext(path, "setFilter");
    }
}

