/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ConfigurationException;
import org.mule.config.ReaderResource;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.config.i18n.Message;
import org.mule.umo.manager.UMOManager;
import org.mule.util.StringUtils;

public class MuleClasspathConfigurationBuilder
extends MuleXmlConfigurationBuilder {
    protected static Log logger = LogFactory.getLog((Class)MuleClasspathConfigurationBuilder.class);
    public static final String MULE_CONFIGURATION_RESOURCE = "mule-config.xml";

    public UMOManager configure(String configResources, String startupPropertiesFile) throws ConfigurationException {
        String[] resString;
        if (StringUtils.isBlank((String)configResources)) {
            configResources = MULE_CONFIGURATION_RESOURCE;
        }
        URL url = null;
        ArrayList<ReaderResource> list = new ArrayList<ReaderResource>();
        int i = 0;
        try {
            resString = StringUtils.splitAndTrim((String)configResources, (String)",");
            for (i = 0; i < resString.length && (url = Thread.currentThread().getContextClassLoader().getResource(resString[i])) != null; ++i) {
                list.add(new ReaderResource(url.toExternalForm(), (Reader)new InputStreamReader(url.openStream())));
            }
        }
        catch (IOException ioe) {
            throw new ConfigurationException(new Message(58, (Object)("Config: " + ObjectUtils.toString(url, (String)"null"))), (Throwable)ioe);
        }
        if (list.size() != resString.length) {
            throw new ConfigurationException(new Message(58, (Object)("Not all resources specified loaded: " + resString[i])));
        }
        ReaderResource[] resources = new ReaderResource[list.size()];
        resources = list.toArray(resources);
        this.configure(resources, null);
        return this.manager;
    }
}

