/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.boot.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.api.DefaultMuleException;

public class CommandLineUtils {
    private static CommandLine parseCommandLine(String[] args, String[][] opts) throws DefaultMuleException {
        Options options = new Options();
        for (int i = 0; i < opts.length; ++i) {
            options.addOption(opts[i][0], opts[i][1].equals("true"), opts[i][2]);
        }
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(options, args, true);
            if (line == null) {
                throw new DefaultMuleException("Unknown error parsing the Mule command line");
            }
            return line;
        }
        catch (ParseException p) {
            throw new DefaultMuleException("Unable to parse the Mule command line because of: " + p.toString(), (Throwable)p);
        }
    }

    public static String getCommandLineOption(String option, String[] args, String[][] opts) throws DefaultMuleException {
        CommandLine line = CommandLineUtils.parseCommandLine(args, opts);
        return line.getOptionValue(option);
    }

    public static boolean hasCommandLineOption(String option, String[] args, String[][] opts) throws DefaultMuleException {
        CommandLine line = CommandLineUtils.parseCommandLine(args, opts);
        return line.hasOption(option);
    }

    public static Map getCommandLineOptions(String[] args, String[][] opts) throws DefaultMuleException {
        CommandLine line = CommandLineUtils.parseCommandLine(args, opts);
        HashMap<String, String> ret = new HashMap<String, String>();
        Option[] options = line.getOptions();
        for (int i = 0; i < options.length; ++i) {
            Option option = options[i];
            ret.put(option.getOpt(), option.getValue("true"));
        }
        return ret;
    }
}

