/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.modules.boot.LicenseHandler;
import org.mule.modules.boot.MuleBootstrapUtils;
import org.mule.modules.boot.MuleServerWrapper;
import org.mule.modules.boot.OsgiFrameworkWrapper;
import org.mule.modules.boot.VersionWrapper;
import org.mule.util.ClassUtils;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperSimpleApp;

public class MuleBootstrap {
    private static final String MULE_MODULE_BOOT_POM_FILE_PATH = "META-INF/maven/org.mule.modules/mule-module-boot/pom.properties";
    public static final String MAIN_CLASS_MULE_SERVER = "org.mule.modules.boot.MuleServerWrapper";
    public static final String MAIN_CLASS_OSGI_FRAMEWORK = "org.mule.modules.osgi.OsgiFrameworkWrapper";
    public static final String[][] CLI_OPTIONS = new String[][]{{"main", "true", "Main Class"}, {"osgi", "false", "Run in an OSGi framework"}, {"nogui", "false", "Suppress graphical console"}, {"version", "false", "Show product and version information"}};

    public static void main(String[] args) throws Exception {
        CommandLine commandLine = MuleBootstrap.parseCommandLine(args);
        String[] remainingArgs = commandLine.getArgs();
        String mainClassName = commandLine.getOptionValue("main");
        if (commandLine.hasOption("version")) {
            MuleBootstrap.prepareBootstrapPhase();
            WrapperManager.start((WrapperListener)new VersionWrapper(), (String[])remainingArgs);
        } else if (commandLine.hasOption("osgi")) {
            boolean startGui = !commandLine.hasOption("nogui");
            System.out.println("Starting the OSGi Framework...");
            WrapperManager.start((WrapperListener)new OsgiFrameworkWrapper(startGui), (String[])remainingArgs);
        } else if (mainClassName == null || mainClassName.equals(MAIN_CLASS_MULE_SERVER)) {
            MuleBootstrap.prepareBootstrapPhase();
            System.out.println("Starting the Mule Server...");
            WrapperManager.start((WrapperListener)((WrapperListener)Class.forName(MAIN_CLASS_MULE_SERVER).newInstance()), (String[])remainingArgs);
        } else {
            String[] appArgs = new String[remainingArgs.length + 1];
            appArgs[0] = mainClassName;
            System.arraycopy(remainingArgs, 0, appArgs, 1, remainingArgs.length);
            MuleBootstrap.prepareBootstrapPhase();
            System.out.println("Starting class " + mainClassName + "...");
            WrapperSimpleApp.main((String[])appArgs);
        }
    }

    private static void prepareBootstrapPhase() throws Exception {
        File muleHome = MuleBootstrap.lookupMuleHome();
        File muleBase = MuleBootstrap.lookupMuleBase();
        if (muleBase == null) {
            muleBase = muleHome;
        }
        MuleBootstrapUtils.addLocalJarFilesToClasspath(muleHome, muleBase);
        MuleBootstrapUtils.addExternalJarFilesToClasspath(muleHome, null);
        MuleBootstrap.setSystemMuleVersion();
        MuleBootstrap.requestLicenseAcceptance();
    }

    private static File lookupMuleHome() throws Exception {
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals("%MULE_HOME%")) {
            muleHome = new File(muleHomeVar).getCanonicalFile();
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either MULE_HOME is not set or does not contain a valid directory.");
        }
        return muleHome;
    }

    private static File lookupMuleBase() throws Exception {
        File muleBase = null;
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            muleBase = new File(muleBaseVar).getCanonicalFile();
        }
        return muleBase;
    }

    private static void requestLicenseAcceptance() throws Exception {
        if (!LicenseHandler.isLicenseAccepted() && !LicenseHandler.getAcceptance()) {
            WrapperManager.stop((int)-1);
        }
    }

    private static void setSystemMuleVersion() {
        try {
            URL mavenPropertiesUrl = ClassUtils.getResource((String)MULE_MODULE_BOOT_POM_FILE_PATH, (Class)MuleServerWrapper.class);
            Properties mavenProperties = new Properties();
            mavenProperties.load(mavenPropertiesUrl.openStream());
            System.setProperty("mule.version", mavenProperties.getProperty("version"));
            System.setProperty("mule.reference.version", mavenProperties.getProperty("version") + '-' + new Date().getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        for (int i = 0; i < CLI_OPTIONS.length; ++i) {
            options.addOption(CLI_OPTIONS[i][0], "true".equalsIgnoreCase(CLI_OPTIONS[i][1]), CLI_OPTIONS[i][2]);
        }
        return new BasicParser().parse(options, args, true);
    }
}

