/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.modules.boot.DefaultMuleClassPathConfig;
import org.mule.modules.boot.LibraryDownloader;
import org.mule.modules.boot.LicenseHandler;
import org.mule.modules.boot.OsgiFrameworkWrapper;
import org.mule.modules.boot.ReflectionHelper;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperSimpleApp;

public class MuleBootstrap {
    public static final String MAIN_CLASS_MULE_SERVER = "org.mule.modules.boot.MuleServerWrapper";
    public static final String MAIN_CLASS_OSGI_FRAMEWORK = "org.mule.modules.osgi.OsgiFrameworkWrapper";
    public static final String[][] CLI_OPTIONS = new String[][]{{"main", "true", "Main Class"}, {"osgi", "false", "Run in an OSGi framework"}, {"nogui", "false", "Suppress graphical console"}};

    public static void main(String[] args) throws Exception {
        CommandLine commandLine = MuleBootstrap.parseCommandLine(args);
        String[] remainingArgs = commandLine.getArgs();
        String mainClassName = commandLine.getOptionValue("main");
        if (commandLine.hasOption("osgi")) {
            boolean startGui = !commandLine.hasOption("nogui");
            System.out.println("Starting the OSGi Framework...");
            WrapperManager.start((WrapperListener)new OsgiFrameworkWrapper(startGui), (String[])remainingArgs);
        } else if (mainClassName == null || mainClassName.equals(MAIN_CLASS_MULE_SERVER)) {
            MuleBootstrap.configureClasspath();
            System.out.println("Starting the Mule Server...");
            WrapperManager.start((WrapperListener)((WrapperListener)Class.forName(MAIN_CLASS_MULE_SERVER).newInstance()), (String[])remainingArgs);
        } else {
            String[] appArgs = new String[remainingArgs.length + 1];
            appArgs[0] = mainClassName;
            System.arraycopy(remainingArgs, 0, appArgs, 1, remainingArgs.length);
            MuleBootstrap.configureClasspath();
            System.out.println("Starting class " + mainClassName + "...");
            WrapperSimpleApp.main((String[])appArgs);
        }
    }

    private static void configureClasspath() throws Exception {
        LicenseHandler licenseHandler;
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals("%MULE_HOME%")) {
            muleHome = new File(muleHomeVar).getCanonicalFile();
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either MULE_HOME is not set or does not contain a valid directory.");
        }
        String muleBaseVar = System.getProperty("mule.base");
        File muleBase = muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%") ? new File(muleBaseVar).getCanonicalFile() : muleHome;
        DefaultMuleClassPathConfig classPath = new DefaultMuleClassPathConfig(muleHome, muleBase);
        MuleBootstrap.addLibrariesToClasspath(classPath.getURLs());
        if (ReflectionHelper.getResource("META-INF/mule/license.props", MuleBootstrap.class) == null && !(licenseHandler = new LicenseHandler(muleHome, muleBase)).getAcceptance()) {
            ReflectionHelper.wrapperStop(-1);
        }
        if (!ReflectionHelper.isClassOnPath("javax.activation.DataSource", MuleBootstrap.class)) {
            LibraryDownloader downloader = new LibraryDownloader(muleBase);
            MuleBootstrap.addLibrariesToClasspath(downloader.downloadLibraries());
        }
    }

    private static void addLibrariesToClasspath(List urls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader sys = ClassLoader.getSystemClassLoader();
        if (!(sys instanceof URLClassLoader)) {
            throw new IllegalArgumentException("PANIC: Mule has been started with an unsupported classloader: " + sys.getClass().getName() + ". " + "Please report this error to user<at>mule<dot>codehaus<dot>org");
        }
        URLClassLoader sysCl = (URLClassLoader)sys;
        Class refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        for (int i = 0; i < CLI_OPTIONS.length; ++i) {
            options.addOption(CLI_OPTIONS[i][0], "true".equalsIgnoreCase(CLI_OPTIONS[i][1]), CLI_OPTIONS[i][2]);
        }
        return new BasicParser().parse(options, args, true);
    }
}

