/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DefaultMuleClassPathConfig {
    protected static final String FOLDER_MULE = "/lib/mule";
    protected static final String FOLDER_OPT = "/lib/opt";
    protected static final String FOLDER_USER = "/lib/user";
    private List urls = new LinkedList();
    private String muleHome = System.getProperty("mule.home");

    public DefaultMuleClassPathConfig() {
        if (this.muleHome == null || this.muleHome.trim().length() == 0) {
            throw new IllegalArgumentException("Either MULE_HOME is not set or mule.home system property is missing.");
        }
        try {
            File jar;
            int i;
            this.addURL(new URL("file:///" + this.muleHome + FOLDER_USER + "/"));
            this.addURL(new URL("file:///" + this.muleHome + FOLDER_MULE + "/"));
            this.addURL(new URL("file:///" + this.muleHome + FOLDER_OPT + "/"));
            File[] muleJars = this.listJars(FOLDER_USER);
            for (i = 0; i < muleJars.length; ++i) {
                jar = muleJars[i];
                this.addURL(jar.toURL());
            }
            muleJars = this.listJars(FOLDER_MULE);
            for (i = 0; i < muleJars.length; ++i) {
                jar = muleJars[i];
                this.addURL(jar.toURL());
            }
            muleJars = this.listJars(FOLDER_OPT);
            for (i = 0; i < muleJars.length; ++i) {
                jar = muleJars[i];
                this.addURL(jar.toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to construct a classpath URL", e);
        }
    }

    public List getURLs() {
        return new ArrayList(this.urls);
    }

    public void addURLs(List urls) {
        if (urls != null && !urls.isEmpty()) {
            this.urls.addAll(urls);
        }
    }

    public void addURL(URL url) {
        this.urls.add(url);
    }

    protected File[] listJars(String muleSubfolder) {
        String fullPath = this.muleHome + muleSubfolder;
        File path = new File(fullPath);
        File[] jars = path.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                try {
                    return pathname.getCanonicalPath().endsWith(".jar");
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        });
        return jars == null ? new File[]{} : jars;
    }
}

