/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DefaultMuleClassPathConfig {
    protected static final String FOLDER_MULE = "/lib/mule";
    protected static final String FOLDER_OPT = "/lib/opt";
    protected static final String FOLDER_USER = "/lib/user";
    private List urls = new LinkedList();

    public DefaultMuleClassPathConfig(File muleHome) {
        try {
            File jar;
            int i;
            this.addURL(new URL("file://" + muleHome.getAbsolutePath() + FOLDER_USER + "/"));
            this.addURL(new URL("file://" + muleHome.getAbsolutePath() + FOLDER_MULE + "/"));
            this.addURL(new URL("file://" + muleHome.getAbsolutePath() + FOLDER_OPT + "/"));
            File[] muleJars = this.listJars(muleHome, FOLDER_USER);
            for (i = 0; i < muleJars.length; ++i) {
                jar = muleJars[i];
                this.addURL(jar.toURL());
            }
            muleJars = this.listJars(muleHome, FOLDER_MULE);
            for (i = 0; i < muleJars.length; ++i) {
                jar = muleJars[i];
                this.addURL(jar.toURL());
            }
            muleJars = this.listJars(muleHome, FOLDER_OPT);
            for (i = 0; i < muleJars.length; ++i) {
                jar = muleJars[i];
                this.addURL(jar.toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to construct a classpath URL", e);
        }
    }

    public List getURLs() {
        return new ArrayList(this.urls);
    }

    public void addURLs(List urls) {
        if (urls != null && !urls.isEmpty()) {
            this.urls.addAll(urls);
        }
    }

    public void addURL(URL url) {
        this.urls.add(url);
    }

    protected File[] listJars(File muleHome, String muleSubfolder) {
        File path = new File(muleHome, muleSubfolder);
        File[] jars = path.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                try {
                    return pathname.getCanonicalPath().endsWith(".jar");
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        });
        return jars == null ? new File[]{} : jars;
    }
}

