/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.atom.routing;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.module.atom.transformers.ObjectToFeed;
import org.mule.processor.AbstractFilteringMessageProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InboundFeedSplitter
extends AbstractFilteringMessageProcessor {
    protected final transient Log logger = LogFactory.getLog(InboundFeedSplitter.class);
    public static final String FEED_PROPERTY = "feed.object";
    private Filter entryFilter;
    private List<String> acceptedContentTypes;
    private ObjectToFeed objectToFeed = new ObjectToFeed();

    public InboundFeedSplitter() {
        this.acceptedContentTypes = new ArrayList<String>();
        this.acceptedContentTypes.add("application/atom+xml");
    }

    public MuleEvent process(MuleEvent muleEvent) throws MuleException {
        try {
            Object payload = muleEvent.getMessage().getPayload();
            Feed feed = payload instanceof Feed ? (Feed)payload : (Feed)this.objectToFeed.transform(muleEvent.getMessage().getPayload());
            ArrayList<DefaultMuleEvent> events = new ArrayList<DefaultMuleEvent>();
            TreeSet<Entry> entries = new TreeSet<Entry>(new EntryComparator());
            entries.addAll(feed.getEntries());
            for (Entry entry : entries) {
                DefaultMuleMessage m = new DefaultMuleMessage((Object)entry, muleEvent.getMuleContext());
                if (this.entryFilter != null && !this.entryFilter.accept((MuleMessage)m)) continue;
                m.setInvocationProperty(FEED_PROPERTY, (Object)feed);
                DefaultMuleEvent e = new DefaultMuleEvent((MuleMessage)m, muleEvent.getEndpoint(), muleEvent.getFlowConstruct(), muleEvent);
                events.add(e);
            }
            for (MuleEvent muleEvent2 : events) {
                this.processNext(muleEvent2);
            }
        }
        catch (TransformerException e) {
            throw new MessagingException(e.getI18nMessage(), muleEvent, (Throwable)e);
        }
        return null;
    }

    public boolean accept(MuleEvent muleEvent) {
        String contentType = (String)muleEvent.getMessage().getInboundProperty("Content-Type");
        if (contentType != null) {
            int i = contentType.indexOf(";");
            contentType = i > -1 ? contentType.substring(0, i) : contentType;
            return this.acceptedContentTypes.contains(contentType);
        }
        this.logger.warn((Object)"Content-Type header not set, not accepting the message");
        return false;
    }

    public Filter getEntryFilter() {
        return this.entryFilter;
    }

    public void setEntryFilter(Filter entryFilter) {
        this.entryFilter = entryFilter;
    }

    public List<String> getAcceptedContentTypes() {
        return this.acceptedContentTypes;
    }

    public void setAcceptedContentTypes(List<String> acceptedContentTypes) {
        this.acceptedContentTypes = acceptedContentTypes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryComparator
    implements Comparator<Entry> {
        EntryComparator() {
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            if (e1.getPublished().before(e2.getPublished())) {
                return -1;
            }
            if (e1.equals(e2)) {
                return 0;
            }
            return 1;
        }
    }
}

