/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.xml.validation.Schema;
import org.mule.api.MuleContext;
import org.mule.api.registry.RegistrationException;
import org.mule.module.apikit.validation.cache.XmlSchemaCacheLoader;
import org.mule.raml.interfaces.model.IRaml;

public final class XmlSchemaCache {
    private static final String REGISTRY_XML_SCHEMA_CACHE_KEY_PREFIX = "__restRouterXmlSchemaCache__";

    public static LoadingCache<String, Schema> getXmlSchemaCache(MuleContext muleContext, String configId, IRaml api) throws RegistrationException {
        String cacheKey = REGISTRY_XML_SCHEMA_CACHE_KEY_PREFIX + configId;
        if (muleContext.getRegistry().get(cacheKey) == null) {
            LoadingCache transformerCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new XmlSchemaCacheLoader(api));
            muleContext.getRegistry().registerObject(cacheKey, (Object)transformerCache);
        }
        return (LoadingCache)muleContext.getRegistry().get(cacheKey);
    }
}

