/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.util;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.module.apikit.odata.exception.ODataInvalidFormatException;
import org.mule.module.apikit.odata.exception.ODataInvalidUriException;
import org.mule.runtime.api.util.MultiMap;
import org.odata4j.producer.resources.OptionsQueryParser;

public class ODataUriHelper {
    public static final String REST_ENTITY_REGEXP = "^(/(\\w|\\-)+)*/?$";
    public static final String[] ODATA_VALID_PARAMS = new String[]{"$orderby", "$top", "$skip", "$filter", "$expand", "$format", "$select", "$inlinecount"};
    public static final String[] ODATA_LIST_PARAMS = new String[]{"$orderby", "$inlinecount", "$skip", "$top"};
    public static final String ODATA_RESOURCE_REGEXP = "^/((\\w|\\-)+)(\\(((\\w|\\-)+|'[^']*'|(,?(\\w|\\-)+=((\\w|\\-)+|'[^']*'))+)\\))?(/|/\\$(\\w|\\-)+)?$";
    public static final String ODATA_ENTITY_REGEXP = "^/((\\w|\\-)+)((/|\\().*)?$";
    public static final String ODATA_COLLECTION_REGEXP = "^/((\\w|\\-)+)(/|/\\$(\\w|\\-)+)?$";
    public static final String ODATA_SINGLE_KEY_REGEXP = "^(\\d+L{0,1}|'[^']*')$";
    public static final String ODATA_MULTIPLE_KEYS_REGEXP = "^(((\\w|\\-)+)=((\\w|\\-)+|'[^']*'),?)+$";
    public static final String ODATA_ORDERBY_REGEXP = "^((\\w|\\-)+(/\\w)?(\\s(desc|asc))?(,\\s*(\\w|\\-)+(/\\w)?(\\s(desc|asc))?)*)+$";
    public static final String ODATA_TOP_REGEXP = "^\\d+$";
    public static final String ODATA_SKIP_REGEXP = "^\\d+$";
    public static final String ODATA_EXPAND_REGEXP = "^(\\w|\\-)+(/(\\w|\\-)+)?(,\\s*(\\w|\\-)+(/(\\w|\\-)+)?)*$";
    public static final String ODATA_FORMAT_REGEXP = "^(atom|json|xml)$";
    public static final String ODATA_INLINECOUNT_REGEXP = "^(allpages|none)$";
    public static final String ODATA_PRIMITIVE_STRING_REGEXP = "^'([^']*)'$";
    public static final String ODATA_LONG_REGEXP = "^(\\d+L)$";
    public static final Pattern REST_ENTITY_PATTERN = Pattern.compile("^(/(\\w|\\-)+)*/?$");
    public static final Pattern ODATA_RESOURCE_PATTERN = Pattern.compile("^/((\\w|\\-)+)(\\(((\\w|\\-)+|'[^']*'|(,?(\\w|\\-)+=((\\w|\\-)+|'[^']*'))+)\\))?(/|/\\$(\\w|\\-)+)?$");
    public static final Pattern ODATA_ENTITY_PATTERN = Pattern.compile("^/((\\w|\\-)+)((/|\\().*)?$");
    public static final Pattern ODATA_COLLECTION_PATTERN = Pattern.compile("^/((\\w|\\-)+)(/|/\\$(\\w|\\-)+)?$");
    public static final Pattern ODATA_SINGLE_KEY_PATTERN = Pattern.compile("^(\\d+L{0,1}|'[^']*')$");
    public static final Pattern ODATA_MULTIPLE_KEYS_PATTERN = Pattern.compile("^(((\\w|\\-)+)=((\\w|\\-)+|'[^']*'),?)+$");
    public static final Pattern ODATA_ORDERBY_PATTERN = Pattern.compile("^((\\w|\\-)+(/\\w)?(\\s(desc|asc))?(,\\s*(\\w|\\-)+(/\\w)?(\\s(desc|asc))?)*)+$");
    public static final Pattern ODATA_TOP_PATTERN = Pattern.compile("^\\d+$");
    public static final Pattern ODATA_SKIP_PATTERN = Pattern.compile("^\\d+$");
    public static final Pattern ODATA_EXPAND_PATTERN = Pattern.compile("^(\\w|\\-)+(/(\\w|\\-)+)?(,\\s*(\\w|\\-)+(/(\\w|\\-)+)?)*$");
    public static final Pattern ODATA_FORMAT_PATTERN = Pattern.compile("^(atom|json|xml)$");
    public static final Pattern ODATA_INLINECOUNT_PATTERN = Pattern.compile("^(allpages|none)$");
    public static final Pattern ODATA_PRIMITIVE_STRING_PATTERN = Pattern.compile("^'([^']*)'$");
    public static final Pattern ODATA_LONG_PATTERN = Pattern.compile("^(\\d+L)$");
    private static final String ODATA_SVC_URI_PREFIX = "/odata.svc";
    private static final String SKIP_FILTER_VALIDATION_PROPERTY = "apikit.odata.skipFilterValidation";

    public static boolean isMetadata(String path) {
        return path.contains("$metadata");
    }

    public static boolean isCount(String path) {
        return path.contains("$count");
    }

    public static boolean hasFormat(String query) {
        return query.contains("$format");
    }

    public static boolean isCollection(String path) {
        return ODATA_COLLECTION_PATTERN.matcher(path).matches();
    }

    public static boolean isServiceDocument(String path) {
        return path.isEmpty() || path.equals("/");
    }

    public static boolean isResourceRequest(String path) {
        return ODATA_RESOURCE_PATTERN.matcher(path).matches();
    }

    public static String[] parseRequest(String path) {
        if (path.startsWith(ODATA_SVC_URI_PREFIX)) {
            path = path.replace(ODATA_SVC_URI_PREFIX, "");
        }
        String entity = "";
        String id = "";
        Matcher m = ODATA_RESOURCE_PATTERN.matcher(path);
        if (m.matches()) {
            entity = m.group(1);
            if (m.group(4) != null) {
                id = m.group(4);
            }
        } else if (REST_ENTITY_PATTERN.matcher(path).matches()) {
            if (path.startsWith("/")) {
                return path.substring(1).split("/");
            }
            return path.split("/");
        }
        return new String[]{entity, id};
    }

    public static String parseEntity(String path) {
        Matcher m;
        if (path.startsWith(ODATA_SVC_URI_PREFIX)) {
            path = path.replace(ODATA_SVC_URI_PREFIX, "");
        }
        if ((m = ODATA_ENTITY_PATTERN.matcher(path)).matches()) {
            return m.group(1);
        }
        return "";
    }

    private static boolean matchPattern(Pattern pattern, String value) {
        return pattern.matcher(value).matches();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static HashMap<String, Object> parseKeys(String path, String[] entityKeys) throws ODataInvalidUriException {
        String[] parsedKeys;
        HashMap<String, Object> keys = new HashMap<String, Object>();
        String parsedId = ODataUriHelper.parseRequest(path)[1];
        if (!Strings.isNullOrEmpty((String)parsedId)) {
            if (ODataUriHelper.matchPattern(ODATA_MULTIPLE_KEYS_PATTERN, parsedId)) {
                parsedKeys = parsedId.split(",");
            } else {
                if (!ODataUriHelper.matchPattern(ODATA_SINGLE_KEY_PATTERN, parsedId)) throw new ODataInvalidUriException("Invalid format for key value '" + parsedId + "' should be an int or a string wrapped in single quotes.");
                if (ODataUriHelper.matchPattern(ODATA_LONG_PATTERN, parsedId)) {
                    parsedId = parsedId.substring(0, parsedId.length() - 1);
                } else if (ODataUriHelper.matchPattern(ODATA_PRIMITIVE_STRING_PATTERN, parsedId)) {
                    parsedId = parsedId.replace("'", "");
                }
                parsedKeys = new String[]{parsedId};
            }
        } else {
            parsedKeys = new String[]{};
        }
        if (entityKeys.length == 1) {
            String entityKeyName = entityKeys[0];
            if (parsedKeys.length == 1 && !parsedKeys[0].isEmpty()) {
                String[] id = parsedKeys[0].split("=");
                if (id.length == 1) {
                    keys.put(entityKeyName, id[0]);
                    return keys;
                }
                String key = id[0];
                String value = id[1];
                if (!key.equals(entityKeyName)) throw new ODataInvalidUriException("Invalid key '" + key + "' should be '" + entityKeyName + "'.");
                keys.put(key, value);
                return keys;
            }
            if (parsedKeys.length <= 1) return keys;
            throw new ODataInvalidUriException("Unexpected number of keys: found " + parsedKeys.length + " where " + entityKeys.length + " were expected.");
        }
        if (entityKeys.length <= 1) return keys;
        if (parsedKeys.length != 0 && parsedKeys.length != entityKeys.length) {
            throw new ODataInvalidUriException("Unexpected number of keys: found " + parsedKeys.length + " where " + entityKeys.length + " were expected.");
        }
        String[] stringArray = parsedKeys;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String parsedKey = stringArray[n2];
            String[] parts = parsedKey.split("=");
            String key = parts[0];
            String value = parts[1];
            if (key == null) throw new ODataInvalidUriException("Invalid format for key '" + parsedKey + "'.");
            if (value == null) {
                throw new ODataInvalidUriException("Invalid format for key '" + parsedKey + "'.");
            }
            if (!Arrays.asList(entityKeys).contains(key)) throw new ODataInvalidUriException("Unknown key '" + key + "'.");
            Matcher s = ODATA_PRIMITIVE_STRING_PATTERN.matcher(value);
            if (s.matches()) {
                value = s.group(1);
            }
            keys.put(key, value);
            ++n2;
        }
        return keys;
    }

    public static boolean allowedQuery(String path, String query) throws ODataInvalidUriException {
        block10: {
            String[] queryParams;
            block9: {
                if (query.isEmpty()) {
                    return true;
                }
                queryParams = query.replace("?", "").split("&");
                if (!ODataUriHelper.isMetadata(path) && !ODataUriHelper.isServiceDocument(path)) break block9;
                for (String queryParam : queryParams) {
                    String argument = queryParam.split("=")[0];
                    if (!argument.startsWith("$")) continue;
                    if (argument.equals("$format")) {
                        return true;
                    }
                    if (Arrays.asList(ODATA_VALID_PARAMS).contains(argument)) {
                        throw new ODataInvalidUriException("Query options $select, $expand, $filter, $orderby, $inlinecount, $skip and $top are not supported by this request method or cannot be applied to the requested resource.");
                    }
                    throw new ODataInvalidUriException("The query parameter '" + argument + "' begins with a system-reserved '$' character but is not recognized.");
                }
                break block10;
            }
            if (!ODataUriHelper.isResourceRequest(path)) break block10;
            if (!ODataUriHelper.isCollection(path)) {
                for (String queryParam : queryParams) {
                    String argument = queryParam.split("=")[0];
                    if (!argument.startsWith("$")) continue;
                    if (Arrays.asList(ODATA_LIST_PARAMS).contains(argument)) {
                        throw new ODataInvalidUriException("Query options $orderby, $inlinecount, $skip and $top are not supported by this request method or cannot be applied to the requested resource.");
                    }
                    if (Arrays.asList(ODATA_VALID_PARAMS).contains(argument)) continue;
                    throw new ODataInvalidUriException("The query parameter '" + argument + "' begins with a system-reserved '$' character but is not recognized.");
                }
            } else {
                for (String queryParam : queryParams) {
                    String argument = queryParam.split("=")[0];
                    if (!argument.startsWith("$") || Arrays.asList(ODATA_VALID_PARAMS).contains(argument)) continue;
                    throw new ODataInvalidUriException("The query parameter '" + argument + "' begins with a system-reserved '$' character but is not recognized.");
                }
            }
        }
        return true;
    }

    public static void validQuery(String query, MultiMap<String, String> queryParameters) throws ODataInvalidUriException, ODataInvalidFormatException {
        if (query.isEmpty()) {
            return;
        }
        for (Map.Entry queryParam : queryParameters.entrySet()) {
            if (queryParameters.getAll(queryParam.getKey()).size() > 1) {
                throw new ODataInvalidUriException("The query argument '" + (String)queryParam.getKey() + "' is repeated.");
            }
            if (Strings.isNullOrEmpty((String)((String)queryParam.getValue()))) {
                throw new ODataInvalidUriException("Incorrect format, missing '=' in query argument.");
            }
            ODataUriHelper.validArgumentValue((String)queryParam.getKey(), (String)queryParam.getValue());
        }
    }

    public static boolean validArgumentValue(String argument, String value) throws ODataInvalidUriException, ODataInvalidFormatException {
        switch (argument) {
            case "$orderby": {
                Matcher m = ODATA_ORDERBY_PATTERN.matcher(value);
                if (m.matches()) break;
                throw new ODataInvalidUriException("Incorrect format for $orderby argument '" + value + "'.");
            }
            case "$top": {
                Matcher m = ODATA_TOP_PATTERN.matcher(value);
                if (m.matches()) break;
                throw new ODataInvalidUriException("Incorrect format for $top argument '" + value + "'.");
            }
            case "$skip": {
                Matcher m = ODATA_SKIP_PATTERN.matcher(value);
                if (m.matches()) break;
                throw new ODataInvalidUriException("Incorrect format for $skip argument '" + value + "'.");
            }
            case "$expand": {
                Matcher m = ODATA_EXPAND_PATTERN.matcher(value);
                if (m.matches()) break;
                throw new ODataInvalidUriException("Incorrect format for $expand argument '" + value + "'.");
            }
            case "$format": {
                Matcher m = ODATA_FORMAT_PATTERN.matcher(value);
                if (m.matches()) break;
                throw new ODataInvalidFormatException("Incorrect format for $format argument '" + value + "'.");
            }
            case "$select": {
                if (ODataUriHelper.isValidSelectValue(value)) break;
                throw new ODataInvalidUriException("Incorrect format for $select argument '" + value + "'.");
            }
            case "$inlinecount": {
                Matcher m = ODATA_INLINECOUNT_PATTERN.matcher(value);
                if (m.matches()) break;
                throw new ODataInvalidUriException("Incorrect format for $inlinecount argument '" + value + "'.");
            }
            case "$filter": {
                if (ODataUriHelper.getSkipFilterValidationProperty() || ODataUriHelper.validFilter(value)) break;
                throw new ODataInvalidUriException("Incorrect format for $filter argument '" + value + "'.");
            }
        }
        return true;
    }

    private static boolean isValidSelectValue(String value) {
        return !value.isEmpty() && (!value.contains(",") || !value.substring(value.lastIndexOf(",") + 1).isEmpty());
    }

    private static boolean validFilter(String filter) throws ODataInvalidUriException {
        try {
            OptionsQueryParser.parseFilter((String)filter.replace(".", ""));
            return true;
        }
        catch (Exception e) {
            throw new ODataInvalidUriException(e.getMessage());
        }
    }

    public static String getOdataUrl(String completeUrl) {
        return completeUrl.substring(0, completeUrl.indexOf(ODATA_SVC_URI_PREFIX) + ODATA_SVC_URI_PREFIX.length() + 1);
    }

    private static boolean getSkipFilterValidationProperty() {
        return Boolean.valueOf(System.getProperty(SKIP_FILTER_VALIDATION_PROPERTY, "false"));
    }
}

