/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.metadata;

import java.net.URLDecoder;
import org.mule.module.apikit.model.AMFWrapper;
import org.mule.module.apikit.odata.metadata.OdataMetadataManager;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFieldsException;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFormatException;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionSet;
import org.mule.runtime.api.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdataMetadataManagerImpl
extends OdataMetadataManager {
    private final EntityDefinitionSet entitySet;
    private static Logger logger = LoggerFactory.getLogger(OdataMetadataManagerImpl.class);

    public OdataMetadataManagerImpl(String ramlPath, Scheduler scheduler) throws OdataMetadataFormatException {
        logger.info("Initializing Odata Metadata");
        try {
            AMFWrapper apiWrapper = new AMFWrapper(URLDecoder.decode(ramlPath), scheduler);
            this.entitySet = apiWrapper.getSchemas();
        }
        catch (OdataMetadataFieldsException e) {
            throw new OdataMetadataFormatException(e.getMessage());
        }
        logger.info("Odata Metadata initialized");
    }

    public OdataMetadataManagerImpl(String ramlPath) throws OdataMetadataFormatException {
        this(ramlPath, null);
    }

    @Override
    public EntityDefinitionSet getEntitySet() {
        return this.entitySet;
    }
}

