/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.module.apikit.model.Entity;
import org.mule.module.apikit.odata.exception.ODataInvalidFlowResponseException;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinition;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionProperty;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionSet;
import org.mule.module.apikit.odata.model.Entry;
import org.mule.module.apikit.odata.util.EDMTypeConverter;
import org.mule.runtime.api.util.MultiMap;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmType;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.Responses;

public class Helper {
    public static EntitiesResponse convertEntriesToOEntries(List<Entry> outputEntries, String entitySetName, EntityDefinitionSet metadata1, Integer inlineCount) {
        EdmEntitySet ees = Helper.createMetadata(metadata1).getEdmEntitySet(entitySetName);
        ArrayList<OEntity> entities = new ArrayList<OEntity>();
        for (Entry outputEntry : outputEntries) {
            HashMap<String, Object> keys = new HashMap<String, Object>();
            ArrayList<OProperty> properties = new ArrayList<OProperty>();
            for (EdmProperty edmProperty : ees.getType().getProperties().toList()) {
                String propertyName = edmProperty.getName();
                Object propertyValue = outputEntry.getProperties().get(edmProperty.getName());
                if (propertyValue == null) continue;
                OProperty oProperty = EDMTypeConverter.getOProperty(propertyName, propertyValue, edmProperty.getType());
                properties.add(oProperty);
                if (!ees.getType().getKeys().contains(oProperty.getName())) continue;
                keys.put(oProperty.getName(), oProperty.getValue());
            }
            entities.add(OEntities.create((EdmEntitySet)ees, (OEntityKey)OEntityKey.create(keys), properties, null));
        }
        return Responses.entities(entities, (EdmEntitySet)ees, (Integer)inlineCount, null);
    }

    public static EdmDataServices createMetadata(EntityDefinitionSet metadata) {
        try {
            String namespace = "odata2.namespace";
            ArrayList<EdmEntityType.Builder> entityTypes = new ArrayList<EdmEntityType.Builder>();
            ArrayList<EdmEntitySet.Builder> entitySets = new ArrayList<EdmEntitySet.Builder>();
            for (EntityDefinition entityMetadata : metadata.toList()) {
                ArrayList<EdmProperty.Builder> properties = new ArrayList<EdmProperty.Builder>();
                ArrayList<String> keys = new ArrayList<String>();
                for (EntityDefinitionProperty propertyMetadata : entityMetadata.getProperties()) {
                    EdmProperty.Builder builder = EdmProperty.newBuilder((String)propertyMetadata.getName()).setType((EdmType)EDMTypeConverter.convert(propertyMetadata.getType()));
                    builder.setNullable(propertyMetadata.isNullable());
                    if (propertyMetadata.getDefaultValue() != null) {
                        builder.setDefaultValue(propertyMetadata.getDefaultValue());
                    }
                    if (propertyMetadata.getMaxLength() != null) {
                        builder.setMaxLength(Integer.valueOf(Integer.parseInt(propertyMetadata.getMaxLength())));
                    }
                    if (propertyMetadata.getCollation() != null) {
                        builder.setCollation(propertyMetadata.getCollation());
                    }
                    if (propertyMetadata.isUnicode() != null) {
                        builder.setUnicode(propertyMetadata.isUnicode());
                    }
                    if (propertyMetadata.getPrecision() != null) {
                        builder.setPrecision(Integer.valueOf(Integer.parseInt(propertyMetadata.getPrecision())));
                    }
                    if (propertyMetadata.getScale() != null) {
                        builder.setScale(Integer.valueOf(Integer.parseInt(propertyMetadata.getScale())));
                    }
                    properties.add(builder);
                    if (!propertyMetadata.isKey()) continue;
                    keys.add(propertyMetadata.getName());
                }
                String entityName = entityMetadata.getName();
                EdmEntityType.Builder type = (EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace(namespace)).setName(entityName)).addKeys(keys).addProperties(properties);
                entityTypes.add(type);
                entitySets.add(EdmEntitySet.newBuilder().setName(Entity.pluralizeName(entityName)).setEntityType(type));
            }
            EdmEntityContainer.Builder container = EdmEntityContainer.newBuilder().setName("ODataEntityContainer").setIsDefault(true).addEntitySets(entitySets);
            EdmSchema.Builder containerSchema = EdmSchema.newBuilder().setNamespace("odata2.namespace").addEntityContainers(new EdmEntityContainer.Builder[]{container}).addEntityTypes(entityTypes);
            return EdmDataServices.newBuilder().addSchemas(new EdmSchema.Builder[]{containerSchema}).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MultiMap<String, String> queryToMap(String query) {
        MultiMap queryMap = new MultiMap();
        if (query != null && !"".equals(query)) {
            String[] queries;
            for (String q : queries = query.split("&")) {
                String[] parts = q.split("=");
                queryMap.put((Object)parts[0], (Object)parts[1]);
            }
        }
        return queryMap;
    }

    public static List<Entry> transformJsonToEntryList(String payload) throws ODataInvalidFlowResponseException {
        try {
            ArrayList<Entry> entities = new ArrayList<Entry>();
            JSONObject response = new JSONObject(payload);
            JSONArray objects = response.getJSONArray("entries");
            for (int i = 0; i < objects.length(); ++i) {
                JSONObject j = objects.optJSONObject(i);
                Iterator it = j.keys();
                Entry e = new Entry();
                while (it.hasNext()) {
                    String n = it.next().toString();
                    e.addProperty(n, j.get(n));
                }
                entities.add(e);
            }
            return entities;
        }
        catch (Exception e) {
            throw new ODataInvalidFlowResponseException("Flow response is not a valid json");
        }
    }
}

