/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.metadata;

import java.util.ArrayList;
import java.util.List;
import org.mule.module.apikit.model.Entity;
import org.mule.module.apikit.odata.context.OdataContextVariables;
import org.mule.module.apikit.odata.exception.ODataException;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataEntityNotFoundException;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFieldsException;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFormatException;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinition;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionProperty;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionSet;

public abstract class OdataMetadataManager {
    public abstract EntityDefinitionSet getEntitySet();

    public EntityDefinition getEntityByName(String entityName) throws OdataMetadataEntityNotFoundException, OdataMetadataFormatException, OdataMetadataFieldsException {
        for (EntityDefinition entityDefinition : this.getEntitySet().toList()) {
            String entityDefinitionName = entityDefinition.getName();
            if (!entityDefinitionName.equalsIgnoreCase(entityName) && !Entity.pluralizeName(entityDefinitionName).equalsIgnoreCase(entityName)) continue;
            return entityDefinition;
        }
        throw new OdataMetadataEntityNotFoundException("Entity " + entityName + " not found.");
    }

    public String[] getEntityKeys(String entityName) throws ODataException {
        return this.getEntityByName(entityName).getKeys().split(",");
    }

    public OdataContextVariables getOdataContextVariables(String entity) throws OdataMetadataEntityNotFoundException, OdataMetadataFormatException, OdataMetadataFieldsException {
        if (entity == null) {
            return null;
        }
        EntityDefinition entityDefinition = this.getEntityByName(entity);
        OdataContextVariables odata = new OdataContextVariables(entityDefinition.getRemoteEntity(), entityDefinition.getKeys(), this.getFieldsAsList(entityDefinition.getProperties()));
        return odata;
    }

    private List<String> getFieldsAsList(List<EntityDefinitionProperty> properties) {
        ArrayList<String> ret = new ArrayList<String>();
        for (EntityDefinitionProperty property : properties) {
            ret.add(property.getName());
        }
        return ret;
    }
}

