/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata;

import java.net.URLDecoder;
import java.util.HashMap;
import org.mule.module.apikit.odata.context.OdataContext;
import org.mule.module.apikit.odata.exception.ODataException;
import org.mule.module.apikit.odata.exception.ODataInvalidFormatException;
import org.mule.module.apikit.odata.exception.ODataInvalidUriException;
import org.mule.module.apikit.odata.exception.ODataNotFoundException;
import org.mule.module.apikit.odata.exception.ODataUnsupportedMediaTypeException;
import org.mule.module.apikit.odata.processor.ODataApikitProcessor;
import org.mule.module.apikit.odata.processor.ODataMetadataProcessor;
import org.mule.module.apikit.odata.processor.ODataRequestProcessor;
import org.mule.module.apikit.odata.processor.ODataServiceDocumentProcessor;
import org.mule.module.apikit.odata.util.ODataUriHelper;

public class ODataUriParser {
    private static final String ODATA_SVC_URI_PREFIX = "/odata.svc";

    public static ODataRequestProcessor parse(OdataContext odataContext, String path, String query) throws ODataException {
        if (ODataUriHelper.allowedQuery(path = path.replace(ODATA_SVC_URI_PREFIX, ""), query = ODataUriParser.decodeQuery(query))) {
            if (ODataUriHelper.isMetadata(path)) {
                return new ODataMetadataProcessor(odataContext);
            }
            if (ODataUriHelper.isServiceDocument(path)) {
                return new ODataServiceDocumentProcessor(odataContext);
            }
            if (ODataUriHelper.isResourceRequest(path)) {
                String entity = ODataUriHelper.parseEntity(path);
                String querystring = ODataUriParser.handleQuerystring(query);
                HashMap<String, Object> keys = ODataUriHelper.parseKeys(path, odataContext.getOdataMetadataManager().getEntityKeys(entity));
                boolean count = ODataUriHelper.isCount(path);
                if (count) {
                    if (ODataUriHelper.hasFormat(query)) {
                        throw new ODataUnsupportedMediaTypeException("Unsupported media type requested.");
                    }
                    if (!ODataUriHelper.isCollection(path)) {
                        throw new ODataInvalidUriException("The request URI is not valid, since the segment '" + entity + "' refers to a singleton, and the segment '$count' can only follow a resource collection.>");
                    }
                }
                return new ODataApikitProcessor(odataContext, entity, querystring, keys, count);
            }
            String segment = ODataUriHelper.parseEntity(path);
            throw new ODataNotFoundException("Resource not found for the segment '" + segment + "'.");
        }
        throw new ODataInvalidUriException("Unsupported query.");
    }

    private static String decodeQuery(String query) throws ODataInvalidUriException {
        try {
            return URLDecoder.decode(query, "UTF-8");
        }
        catch (Exception e) {
            throw new ODataInvalidUriException(e.getMessage());
        }
    }

    private static String handleQuerystring(String query) throws ODataInvalidUriException, ODataInvalidFormatException {
        String querystring = "";
        if (ODataUriHelper.validQuery(query)) {
            querystring = query.replace("?", "").replace("$", "");
        }
        return querystring;
    }
}

