/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.odata.exception.ODataException;
import org.mule.module.apikit.odata.exception.ODataUnsupportedMediaTypeException;
import org.mule.module.apikit.odata.formatter.ODataPayloadFormatter;

public class ODataFormatHandler {
    private static String[] xmlMimeTypes = new String[]{"application/atom+xml", "application/atomsvc+xml", "application/xml"};
    private static String[] jsonMimeTypes = new String[]{"application/json"};
    private static String[] plainMimeTypes = new String[]{"text/plain"};
    private static String[] defaultMimeTypes = new String[]{"*/*"};
    private static String[] xmlFormatTypes = new String[]{"atom", "xml"};
    private static String[] jsonFormatTypes = new String[]{"json"};

    public static List<ODataPayloadFormatter.Format> getFormats(HttpRequestAttributes attributes) throws ODataException {
        ArrayList<ODataPayloadFormatter.Format> formats = new ArrayList<ODataPayloadFormatter.Format>();
        String acceptHeader = ODataFormatHandler.getAcceptHeader(attributes);
        String formatQueryParam = ODataFormatHandler.getFormatQueryParam(attributes);
        if (formatQueryParam != null) {
            if (Arrays.asList(xmlFormatTypes).contains(formatQueryParam)) {
                formats.add(ODataPayloadFormatter.Format.Atom);
                return formats;
            }
            if (Arrays.asList(jsonFormatTypes).contains(formatQueryParam)) {
                formats.add(ODataPayloadFormatter.Format.Json);
                return formats;
            }
            throw new ODataUnsupportedMediaTypeException("Unsupported media type requested.");
        }
        if (acceptHeader != null) {
            boolean unsupportedMediaType = true;
            if (ODataFormatHandler.containsAnyOf(acceptHeader, xmlMimeTypes)) {
                formats.add(ODataPayloadFormatter.Format.Atom);
                unsupportedMediaType = false;
            }
            if (ODataFormatHandler.containsAnyOf(acceptHeader, jsonMimeTypes)) {
                formats.add(ODataPayloadFormatter.Format.Json);
                unsupportedMediaType = false;
            }
            if (ODataFormatHandler.containsAnyOf(acceptHeader, plainMimeTypes)) {
                formats.add(ODataPayloadFormatter.Format.Plain);
                unsupportedMediaType = false;
            }
            if (ODataFormatHandler.containsAnyOf(acceptHeader, defaultMimeTypes)) {
                formats.add(ODataPayloadFormatter.Format.Default);
                unsupportedMediaType = false;
            }
            if (unsupportedMediaType) {
                throw new ODataUnsupportedMediaTypeException("Unsupported media type requested.");
            }
            return formats;
        }
        formats.add(ODataPayloadFormatter.Format.Default);
        return formats;
    }

    private static boolean containsAnyOf(String value, String[] array) {
        for (String key : array) {
            if (!value.contains(key)) continue;
            return true;
        }
        return false;
    }

    private static String getAcceptHeader(HttpRequestAttributes attributes) {
        String acceptHeader = (String)attributes.getHeaders().get((Object)"accept");
        if (acceptHeader == null) {
            acceptHeader = defaultMimeTypes[0];
        }
        return acceptHeader.toLowerCase();
    }

    private static String getFormatQueryParam(HttpRequestAttributes attributes) {
        String formatQueryParam = null;
        String queryString = URLDecoder.decode(attributes.getQueryString());
        if (queryString != null && queryString.contains("$format=")) {
            String[] query;
            for (String pair : query = queryString.split("&")) {
                if (!pair.contains("$format=")) continue;
                return pair.replace("$format=", "").toLowerCase();
            }
        }
        return formatQueryParam;
    }
}

