/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.model;

import java.io.File;
import java.io.IOException;
import org.mule.module.apikit.model.RamlGenerator;
import org.mule.module.apikit.odata.util.FileUtils;

public class ODataScaffolderService {
    private static final String LIBRARIES_FOLDER = "/libraries";
    private static final String LIBRARIES_ODATA_RAML = "/libraries/odataLibrary.raml";
    private static final String API_FOLDER = "api";
    private static final String ODATA_MODEL_FILE = "odata.raml";
    private static final String FINAL_RAML_FILE = "api.raml";

    public File generateApi(File model) {
        if (model != null && this.isODataModel(model)) {
            this.copyLibraryFiles(model.getParentFile().getAbsolutePath());
            return this.generateApiRaml(model);
        }
        return null;
    }

    private File generateApiRaml(File model) {
        try {
            String ramlContents = new RamlGenerator().generate(model.toURI().toString());
            String path = model.getCanonicalPath().replace(ODATA_MODEL_FILE, FINAL_RAML_FILE);
            return FileUtils.stringToFile(path, ramlContents);
        }
        catch (Exception e) {
            throw new RuntimeException("Error: " + e.getMessage());
        }
    }

    private void copyLibraryFiles(String absolutePath) {
        try {
            FileUtils.createFolder(absolutePath + LIBRARIES_FOLDER);
            FileUtils.exportResource(LIBRARIES_ODATA_RAML, absolutePath + LIBRARIES_ODATA_RAML);
        }
        catch (Exception e) {
            throw new RuntimeException("Error copying template files", e);
        }
    }

    private boolean isODataModel(File file) {
        try {
            String path = file.getCanonicalPath();
            return path.contains(API_FOLDER + File.separator + ODATA_MODEL_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

