/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.util;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.model.MethodInvocationInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

public class UriInfoImpl
implements UriInfo {
    private static final Logger LOG = LogUtils.getL7dLogger(UriInfoImpl.class);
    private MultivaluedMap<String, String> templateParams;
    private OperationResourceInfoStack stack;
    private boolean caseInsensitiveQueries;
    private String url;

    public UriInfoImpl(String url) {
        this.url = url;
    }

    public UriInfoImpl(MultivaluedMap<String, String> templateParams) {
        this.templateParams = templateParams;
    }

    public URI getAbsolutePath() {
        String path = this.getAbsolutePathAsString();
        return URI.create(path);
    }

    public UriBuilder getAbsolutePathBuilder() {
        return new UriBuilderImpl(this.getAbsolutePath());
    }

    public URI getBaseUri() {
        try {
            return new URL(this.url).toURI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public UriBuilder getBaseUriBuilder() {
        return new UriBuilderImpl(this.getBaseUri());
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        String value = this.doGetPath(decode, true);
        if (value.length() > 1 && value.startsWith("/")) {
            return value.substring(1);
        }
        return value;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return JAXRSUtils.getPathSegments((String)this.getPath(false), (boolean)decode);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (!this.caseInsensitiveQueries) {
            return JAXRSUtils.getStructuredParams((String)this.getQueryString(), (String)"&", (boolean)decode, (boolean)decode);
        }
        MetadataMap queries = new MetadataMap(false, true);
        JAXRSUtils.getStructuredParams((MultivaluedMap)queries, (String)this.getQueryString(), (String)"&", (boolean)decode, (boolean)decode);
        return queries;
    }

    private String getQueryString() {
        return "";
    }

    public URI getRequestUri() {
        String path = this.getAbsolutePathAsString();
        String queries = this.getQueryString();
        if (queries != null) {
            path = path + "?" + queries;
        }
        return URI.create(path);
    }

    public UriBuilder getRequestUriBuilder() {
        return new UriBuilderImpl(this.getRequestUri());
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        MetadataMap values = new MetadataMap();
        if (this.templateParams == null) {
            return values;
        }
        for (Map.Entry entry : this.templateParams.entrySet()) {
            if (((String)entry.getKey()).equals("FINAL_MATCH_GROUP")) continue;
            values.add(entry.getKey(), (Object)(decode ? HttpUtils.pathDecode((String)((String)((List)entry.getValue()).get(0))) : (String)((List)entry.getValue()).get(0)));
        }
        return values;
    }

    public List<Object> getMatchedResources() {
        if (this.stack != null) {
            LinkedList<Object> resources = new LinkedList<Object>();
            for (MethodInvocationInfo invocation : this.stack) {
                resources.add(0, invocation.getRealClass());
            }
            return resources;
        }
        LOG.fine("No resource stack information, returning empty list");
        return Collections.emptyList();
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        if (this.stack != null) {
            ArrayList objects = new ArrayList();
            LinkedList<String> uris = new LinkedList<String>();
            String sum = "";
            for (MethodInvocationInfo invocation : this.stack) {
                URITemplate[] paths;
                OperationResourceInfo ori = invocation.getMethodInfo();
                for (URITemplate t : paths = new URITemplate[]{ori.getClassResourceInfo().getURITemplate(), ori.getURITemplate()}) {
                    if (t == null) continue;
                    String v = t.getValue();
                    sum = sum + "/" + (decode ? HttpUtils.pathDecode((String)v) : v);
                }
                UriBuilder ub = UriBuilder.fromPath((String)sum);
                objects.addAll(invocation.getTemplateValues());
                uris.add(0, ub.build(objects.toArray()).normalize().getPath());
            }
            return uris;
        }
        LOG.fine("No resource stack information, returning empty list");
        return Collections.emptyList();
    }

    private String doGetPath(boolean decode, boolean addSlash) {
        return "";
    }

    private String getAbsolutePathAsString() {
        return "";
    }

    public URI relativize(URI arg0) {
        return null;
    }

    public URI resolve(URI arg0) {
        return null;
    }
}

