/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.util;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.json.JSONObject;
import org.mule.module.apikit.odata.util.DateParser;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.core.UnsignedByte;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;

public class EDMTypeConverter {
    public static final String EDM_STRING = "Edm.String";
    public static final String EDM_DATETIME = "Edm.DateTime";
    public static final String EDM_BOOLEAN = "Edm.Boolean";
    public static final String EDM_DECIMAL = "Edm.Decimal";
    public static final String EDM_DOUBLE = "Edm.Double";
    public static final String EDM_SINGLE = "Edm.Single";
    public static final String EDM_INT16 = "Edm.Int16";
    public static final String EDM_INT32 = "Edm.Int32";
    public static final String EDM_INT64 = "Edm.Int64";
    public static final String EDM_TIME = "Edm.Time";
    public static final String EDM_DATETIMEOFFSET = "Edm.DateTimeOffset";
    public static final String EDM_BINARY = "Edm.Binary";
    public static final String EDM_BYTE = "Edm.Byte";
    public static final String EDM_GUID = "Edm.Guid";
    public static final String EDM_SBYTE = "Edm.SByte";

    public static EdmSimpleType convert(String type) {
        if (type.equals(EDM_STRING)) {
            return EdmSimpleType.STRING;
        }
        if (type.equals(EDM_DATETIME)) {
            return EdmSimpleType.DATETIME;
        }
        if (type.equals(EDM_BOOLEAN)) {
            return EdmSimpleType.BOOLEAN;
        }
        if (type.equals(EDM_DECIMAL)) {
            return EdmSimpleType.DECIMAL;
        }
        if (type.equals(EDM_DOUBLE)) {
            return EdmSimpleType.DOUBLE;
        }
        if (type.equals(EDM_SINGLE)) {
            return EdmSimpleType.SINGLE;
        }
        if (type.equals(EDM_INT16)) {
            return EdmSimpleType.INT16;
        }
        if (type.equals(EDM_INT32)) {
            return EdmSimpleType.INT32;
        }
        if (type.equals(EDM_INT64)) {
            return EdmSimpleType.INT64;
        }
        if (type.equals(EDM_TIME)) {
            return EdmSimpleType.TIME;
        }
        if (type.equals(EDM_DATETIMEOFFSET)) {
            return EdmSimpleType.DATETIMEOFFSET;
        }
        if (type.equals(EDM_BINARY)) {
            return EdmSimpleType.BINARY;
        }
        if (type.equals(EDM_BYTE)) {
            return EdmSimpleType.BYTE;
        }
        if (type.equals(EDM_GUID)) {
            return EdmSimpleType.GUID;
        }
        if (type.equals(EDM_SBYTE)) {
            return EdmSimpleType.SBYTE;
        }
        return EdmSimpleType.STRING;
    }

    public static OProperty getOProperty(String name, Object value, EdmType type) {
        if (type.equals((Object)EdmSimpleType.INT16)) {
            if (value != null && value != JSONObject.NULL) {
                return OProperties.int16((String)name, (Short)Short.valueOf(String.valueOf(value)));
            }
            return OProperties.int16((String)name, null);
        }
        if (type.equals((Object)EdmSimpleType.INT32)) {
            if (value != null && value != JSONObject.NULL) {
                return OProperties.int32((String)name, (Integer)Integer.valueOf(String.valueOf(value)));
            }
            return OProperties.int32((String)name, null);
        }
        if (type.equals((Object)EdmSimpleType.INT64)) {
            if (value != null && value != JSONObject.NULL) {
                return OProperties.int64((String)name, (Long)Long.valueOf(String.valueOf(value)));
            }
            return OProperties.int64((String)name, null);
        }
        if (type.equals((Object)EdmSimpleType.BINARY)) {
            if (value != null && value != JSONObject.NULL) {
                return OProperties.binary((String)name, (byte[])String.valueOf(value).getBytes());
            }
            return OProperties.binary((String)name, (byte[])new byte[0]);
        }
        if (type.equals((Object)EdmSimpleType.BOOLEAN)) {
            if (value != null && value != JSONObject.NULL) {
                return OProperties.boolean_((String)name, (Boolean)Boolean.valueOf(String.valueOf(value)));
            }
            return OProperties.boolean_((String)name, null);
        }
        if (type.equals((Object)EdmSimpleType.BYTE)) {
            if (value != null && value != JSONObject.NULL) {
                return OProperties.byte_((String)name, (UnsignedByte)UnsignedByte.parseUnsignedByte((String)String.valueOf(value)));
            }
            return OProperties.byte_((String)name, null);
        }
        if (type.equals((Object)EdmSimpleType.DATETIME)) {
            if (value != null && value != JSONObject.NULL) {
                return OProperties.datetime((String)name, (Date)DateParser.parse(String.valueOf(value)));
            }
            LocalDateTime date = null;
            return OProperties.datetime((String)name, date);
        }
        if (type.equals((Object)EdmSimpleType.DATETIMEOFFSET)) {
            if (value != null && value != JSONObject.NULL) {
                Date d = DateParser.parse(String.valueOf(value));
                if (d != null && value != JSONObject.NULL) {
                    return OProperties.datetimeOffset((String)name, (DateTime)new DateTime((Object)d));
                }
                DateTime date = null;
                return OProperties.datetimeOffset((String)name, date);
            }
            DateTime date = null;
            return OProperties.datetimeOffset((String)name, date);
        }
        if (type.equals((Object)EdmSimpleType.DECIMAL)) {
            if (value != null && value != JSONObject.NULL) {
                return OProperties.decimal((String)name, (BigDecimal)BigDecimal.valueOf(Double.valueOf(String.valueOf(value))));
            }
            BigDecimal bd = null;
            return OProperties.decimal((String)name, bd);
        }
        if (type.equals((Object)EdmSimpleType.DOUBLE)) {
            if (value != null && value != JSONObject.NULL) {
                return OProperties.double_((String)name, (Double)Double.valueOf(String.valueOf(value)));
            }
            return OProperties.double_((String)name, null);
        }
        if (type.equals((Object)EdmSimpleType.SINGLE)) {
            if (value != null && value != JSONObject.NULL) {
                return OProperties.single((String)name, (Float)Float.valueOf(String.valueOf(value)));
            }
            return OProperties.single((String)name, null);
        }
        if (type.equals((Object)EdmSimpleType.SBYTE)) {
            if (value != null && value != JSONObject.NULL) {
                return OProperties.sbyte_((String)name, (byte)Byte.valueOf(String.valueOf(value)));
            }
            byte b = 0;
            return OProperties.sbyte_((String)name, (byte)b);
        }
        if (type.equals((Object)EdmSimpleType.TIME)) {
            if (value != null && value != JSONObject.NULL) {
                Date d = DateParser.parse(String.valueOf(value));
                if (d != null) {
                    return OProperties.time((String)name, (Date)d);
                }
                Time t = null;
                return OProperties.time((String)name, t);
            }
            Time t = null;
            return OProperties.time((String)name, t);
        }
        if (value != null && value != JSONObject.NULL) {
            return OProperties.string((String)name, (String)String.valueOf(value));
        }
        return OProperties.string((String)name, null);
    }
}

