/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.processor;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.module.apikit.odata.AbstractRouterInterface;
import org.mule.module.apikit.odata.ODataPayload;
import org.mule.module.apikit.odata.context.OdataContext;
import org.mule.module.apikit.odata.exception.ClientErrorException;
import org.mule.module.apikit.odata.exception.ODataInvalidFlowResponseException;
import org.mule.module.apikit.odata.exception.ODataInvalidUriException;
import org.mule.module.apikit.odata.exception.ODataUnsupportedMediaTypeException;
import org.mule.module.apikit.odata.formatter.ODataApiKitFormatter;
import org.mule.module.apikit.odata.formatter.ODataPayloadFormatter;
import org.mule.module.apikit.odata.metadata.OdataMetadataManager;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataEntityNotFoundException;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFieldsException;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFormatException;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataResourceNotFound;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinition;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionProperty;
import org.mule.module.apikit.odata.model.Entry;
import org.mule.module.apikit.odata.processor.BodyToJsonConverter;
import org.mule.module.apikit.odata.processor.ODataRequestProcessor;
import org.mule.module.apikit.odata.util.CoreEventUtils;
import org.mule.module.apikit.odata.util.Helper;
import org.mule.module.apikit.odata.util.ODataUriHelper;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.event.CoreEvent;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ODataApikitProcessor
extends ODataRequestProcessor {
    private static final String[] methodsWithBody = new String[]{"POST", "PUT"};
    private String path;
    private String query;
    private String entity;
    private boolean entityCount;
    private Map<String, Object> keys;

    public ODataApikitProcessor(OdataContext odataContext, String entity, String query, Map<String, Object> keys, boolean count) throws ODataInvalidUriException {
        super(odataContext);
        this.query = query;
        this.entity = entity;
        this.entityCount = count;
        this.keys = keys;
        this.path = this.generatePath(entity, keys);
    }

    private static int checkResponseHttpStatus(CoreEvent response) throws ClientErrorException {
        String status = ((TypedValue)response.getVariables().get("httpStatus")).getValue().toString();
        int httpStatus = 0;
        try {
            httpStatus = Integer.valueOf(status);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (httpStatus >= 400) {
            String payload = CoreEventUtils.getPayloadAsString(response);
            throw new ClientErrorException(payload != null ? payload.toString() : "", httpStatus);
        }
        return httpStatus;
    }

    private static ODataPayloadFormatter.InlineCount getInlineCountParam(CoreEvent event) {
        HttpRequestAttributes attributes = (HttpRequestAttributes)event.getMessage().getAttributes().getValue();
        if (attributes == null) {
            return ODataPayloadFormatter.InlineCount.NONE;
        }
        MultiMap queryParams = attributes.getQueryParams();
        String inlineCountParameterValue = (String)queryParams.get((Object)"$inlinecount");
        if ("allpages".equalsIgnoreCase(inlineCountParameterValue)) {
            return ODataPayloadFormatter.InlineCount.ALL_PAGES;
        }
        return ODataPayloadFormatter.InlineCount.NONE;
    }

    private String generatePath(String entity, Map<String, Object> keys) throws ODataInvalidUriException {
        String path = "";
        if (keys.size() == 0) {
            path = "/" + entity;
        } else if (keys.size() == 1) {
            String key = (String)keys.keySet().toArray()[0];
            String id = (String)keys.get(key);
            path = "/" + entity + "/" + this.encode(id);
        } else if (keys.size() > 1) {
            path = "/" + entity + "/";
            String uriKeys = "";
            String delimiter = "";
            for (Map.Entry<String, Object> entry : keys.entrySet()) {
                uriKeys = uriKeys + delimiter + entry.getKey() + "_" + entry.getValue();
                delimiter = " :: ";
            }
            List<String> parsedKeys = Arrays.asList(uriKeys.split(" :: "));
            Collections.sort(parsedKeys);
            path = path + StringUtils.join(parsedKeys, (String)"-");
        }
        return path;
    }

    private String encode(String id) throws ODataInvalidUriException {
        try {
            return URLEncoder.encode(id, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataInvalidUriException("Unable to encode entity id");
        }
    }

    @Override
    public ODataPayload process(CoreEvent event, AbstractRouterInterface router, List<ODataPayloadFormatter.Format> formats) throws Exception {
        String oDataURL = this.getCompleteUrl(CoreEventUtils.getHttpRequestAttributes(event));
        oDataURL = ODataUriHelper.getOdataUrl(oDataURL);
        ODataPayload<List<Entry>> oDataPayload = this.processEntityRequest(event, router, formats);
        List<Entry> entries = oDataPayload.getValue();
        if (this.isEntityCount()) {
            if (formats.contains((Object)ODataPayloadFormatter.Format.Plain) || formats.contains((Object)ODataPayloadFormatter.Format.Default)) {
                String count = String.valueOf(entries.size());
                return new ODataPayload<String>(oDataPayload.getMuleEvent(), count, oDataPayload.getStatus());
            }
            throw new ODataUnsupportedMediaTypeException("Unsupported media type requested.");
        }
        oDataPayload.setFormatter(new ODataApiKitFormatter(this.getMetadataManager(), this.entity, oDataURL, entries, oDataPayload.getInlineCount(ODataApikitProcessor.getInlineCountParam(event))));
        return oDataPayload;
    }

    public ODataPayload<List<Entry>> processEntityRequest(CoreEvent event, AbstractRouterInterface router, List<ODataPayloadFormatter.Format> formats) throws Exception {
        Message message;
        HttpRequestAttributes attributes = CoreEventUtils.getHttpRequestAttributes(event);
        HttpRequestAttributes httpRequestAttributes = this.getHttpRequestAttributes(attributes);
        if (Arrays.asList(methodsWithBody).contains(attributes.getMethod().toUpperCase())) {
            String payloadAsString = CoreEventUtils.getPayloadAsString(event);
            if (payloadAsString == null) {
                payloadAsString = "";
            }
            boolean isXMLFormat = !formats.contains((Object)ODataPayloadFormatter.Format.Json);
            payloadAsString = BodyToJsonConverter.convertPayload(this.entity, isXMLFormat, payloadAsString);
            message = Message.builder().value((Object)payloadAsString).mediaType(MediaType.APPLICATION_JSON).attributesValue((Object)httpRequestAttributes).build();
        } else {
            message = Message.builder((Message)event.getMessage()).attributesValue((Object)httpRequestAttributes).build();
        }
        CoreEvent odataEvent = CoreEvent.builder((CoreEvent)event).message(message).addVariable("odata", (Object)this.getMetadataManager().getOdataContextVariables(this.entity)).build();
        Publisher<CoreEvent> processResponse = router.processEvent(odataEvent);
        CoreEvent response = (CoreEvent)Mono.from(processResponse).onErrorMap(error -> new ODataInvalidFlowResponseException(error.getMessage())).block();
        return this.verifyFlowResponse(response);
    }

    private HttpRequestAttributes getHttpRequestAttributes(HttpRequestAttributes attributes) {
        String uri = attributes.getRelativePath();
        String basePath = uri.substring(0, uri.toLowerCase().indexOf("/odata.svc"));
        String httpRequest = basePath + this.path + "?" + this.query;
        String httpRequestPath = basePath + this.path;
        HttpRequestAttributesBuilder httpRequestAttributesBuilder = new HttpRequestAttributesBuilder();
        httpRequestAttributesBuilder.listenerPath(attributes.getListenerPath());
        httpRequestAttributesBuilder.relativePath(this.path);
        httpRequestAttributesBuilder.version(attributes.getVersion());
        httpRequestAttributesBuilder.scheme(attributes.getScheme());
        httpRequestAttributesBuilder.method(attributes.getMethod());
        httpRequestAttributesBuilder.requestPath(httpRequestPath);
        httpRequestAttributesBuilder.requestUri(httpRequest);
        httpRequestAttributesBuilder.queryString(this.query);
        httpRequestAttributesBuilder.localAddress(attributes.getLocalAddress());
        httpRequestAttributesBuilder.remoteAddress(attributes.getRemoteAddress());
        MultiMap<String, String> httpQueryParams = Helper.queryToMap(this.query);
        httpRequestAttributesBuilder.queryParams(httpQueryParams);
        MultiMap headers = new MultiMap();
        headers.put((Object)"host", (Object)attributes.getRemoteAddress());
        headers.put((Object)"content-type", (Object)MediaType.APPLICATION_JSON.toString());
        httpRequestAttributesBuilder.headers(headers);
        return httpRequestAttributesBuilder.build();
    }

    private ODataPayload<List<Entry>> verifyFlowResponse(CoreEvent event) throws OdataMetadataEntityNotFoundException, OdataMetadataFieldsException, OdataMetadataResourceNotFound, OdataMetadataFormatException, ODataInvalidFlowResponseException, ClientErrorException {
        int httpStatus = ODataApikitProcessor.checkResponseHttpStatus(event);
        OdataMetadataManager metadataManager = this.getMetadataManager();
        EntityDefinition entityDefinition = metadataManager.getEntityByName(this.entity);
        String payload = CoreEventUtils.getPayloadAsString(event);
        List<Entry> entries = Strings.isNullOrEmpty((String)payload) ? new ArrayList<Entry>() : Helper.transformJsonToEntryList(payload);
        int entryNumber = 1;
        for (Entry entry : entries) {
            if (entry.getProperties().entrySet().size() > entityDefinition.getProperties().size()) {
                throw new ODataInvalidFlowResponseException("There are absent properties in flow response (entry #" + entryNumber++ + ")");
            }
            for (String propertyName : entry.getProperties().keySet()) {
                EntityDefinitionProperty entityDefinitionProperty = entityDefinition.findPropertyDefinition(propertyName);
                if (entityDefinitionProperty != null) continue;
                throw new ODataInvalidFlowResponseException("Property '" + propertyName + "' was not expected for entity '" + entityDefinition.getName() + "'");
            }
        }
        return new ODataPayload<List<Entry>>(event, entries, httpStatus);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isEntityCount() {
        return this.entityCount;
    }

    public Map<String, Object> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<String, Object> keys) {
        this.keys = keys;
    }
}

