/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.metadata.model.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionProperty;

public class EntityDefinition
implements Comparable<EntityDefinition> {
    private String name;
    private List<EntityDefinitionProperty> properties;
    private String remoteEntity;
    private boolean hasPrimaryKey = false;

    public EntityDefinition(String name, List<EntityDefinitionProperty> properties, String remoteEntity) {
        this.name = name;
        this.remoteEntity = remoteEntity;
        this.properties = properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hasPrimaryKey ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.remoteEntity == null ? 0 : this.remoteEntity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityDefinition other = (EntityDefinition)obj;
        if (this.hasPrimaryKey != other.hasPrimaryKey) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return !(this.remoteEntity == null ? other.remoteEntity != null : !this.remoteEntity.equals(other.remoteEntity));
    }

    public EntityDefinition(String name, String remoteEntity) {
        this.name = name;
        this.remoteEntity = remoteEntity;
        this.properties = new ArrayList<EntityDefinitionProperty>();
    }

    public boolean hasPrimaryKey() {
        return this.hasPrimaryKey;
    }

    public void setHasPrimaryKey(boolean hasPrimaryKey) {
        this.hasPrimaryKey = hasPrimaryKey;
    }

    public void addProperty(EntityDefinitionProperty entityProperty) {
        this.properties.add(entityProperty);
        Collections.sort(this.properties);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<EntityDefinitionProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<EntityDefinitionProperty> properties) {
        this.properties = properties;
        Collections.sort(properties);
    }

    public String getRemoteEntity() {
        return this.remoteEntity;
    }

    public void setRemoteEntity(String remoteEntity) {
        this.remoteEntity = remoteEntity;
    }

    public String toString() {
        return this.toJsonString();
    }

    public String toJsonString() {
        StringBuilder ret = new StringBuilder("{");
        ret.append("\"remoteEntity\":\"" + this.remoteEntity + "\",");
        ret.append("\"hasPrimaryKey\":" + this.hasPrimaryKey + ",");
        ret.append("\"properties\":[");
        String delim = "";
        for (EntityDefinitionProperty property : this.properties) {
            ret.append(delim + property.toJsonString());
            delim = ",";
        }
        ret.append("]}");
        return ret.toString();
    }

    @Override
    public int compareTo(EntityDefinition o) {
        return this.name.compareTo(o.name);
    }

    public String getKeys() {
        StringBuilder ret = new StringBuilder("");
        String delim = "";
        for (EntityDefinitionProperty property : this.properties) {
            if (property.isKey()) {
                Logger.getLogger(this.getClass()).debug((Object)("Property " + property.getName() + " is key. "));
                ret.append(delim + property.getName());
                delim = ",";
                continue;
            }
            Logger.getLogger(this.getClass()).debug((Object)("Property " + property.getName() + " is not key. "));
        }
        return ret.toString();
    }

    public EntityDefinitionProperty findPropertyDefinition(String propertyName) {
        for (EntityDefinitionProperty entityDefinitionProperty : this.properties) {
            if (!entityDefinitionProperty.getName().equals(propertyName)) continue;
            return entityDefinitionProperty;
        }
        return null;
    }
}

