/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata.formatter;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import org.mule.module.apikit.odata.formatter.ODataPayloadFormatter;
import org.mule.module.apikit.odata.metadata.OdataMetadataManager;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionSet;
import org.mule.module.apikit.odata.model.Entry;
import org.mule.module.apikit.odata.util.Helper;
import org.mule.module.apikit.odata.util.UriInfoImpl;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.FormatWriterFactory;
import org.odata4j.producer.EntitiesResponse;

public class ODataApiKitFormatter
extends ODataPayloadFormatter {
    private List<Entry> entries;
    private Integer totalEntitiesCount;
    private String entityName;
    private String url;
    private OdataMetadataManager odataMetadataManager;

    public ODataApiKitFormatter(OdataMetadataManager odataMetadataManager, String entityName, String url, List<Entry> entities, Integer totalEntitiesCount) {
        this.odataMetadataManager = odataMetadataManager;
        this.entityName = entityName;
        this.url = url;
        this.entries = entities;
        this.totalEntitiesCount = totalEntitiesCount;
        this.setSupportsAtom(true);
    }

    @Override
    public String format(ODataPayloadFormatter.Format format) throws Exception {
        if (ODataPayloadFormatter.Format.Default.equals((Object)format)) {
            format = ODataPayloadFormatter.Format.Atom;
        }
        FormatWriter fw = FormatWriterFactory.getFormatWriter(EntitiesResponse.class, Arrays.asList(MediaType.valueOf((String)"*/*")), (String)format.name(), null);
        EntityDefinitionSet entitySet = this.odataMetadataManager.getEntitySet();
        EntitiesResponse entitiesResponse = Helper.convertEntriesToOEntries(this.entries, this.entityName, entitySet, this.totalEntitiesCount);
        StringWriter sw = new StringWriter();
        UriInfoImpl uriInfo = new UriInfoImpl(this.url);
        fw.write((UriInfo)uriInfo, (Writer)sw, (Object)entitiesResponse);
        return sw.toString();
    }
}

