/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata;

import org.apache.log4j.Logger;
import org.mule.module.apikit.api.exception.ApikitRuntimeException;
import org.mule.module.apikit.api.spi.AbstractRouter;
import org.mule.module.apikit.api.spi.RouterService;
import org.mule.module.apikit.odata.AbstractODataRouterService;
import org.mule.module.apikit.odata.context.OdataContext;
import org.mule.module.apikit.odata.metadata.OdataMetadataManagerImpl;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFormatException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.reactivestreams.Publisher;

public class ODataRouterService
extends AbstractODataRouterService
implements RouterService {
    private static Logger logger = Logger.getLogger(ODataRouterService.class);
    private OdataContext oDataContext;

    public RouterService initialise(String raml) {
        try {
            this.oDataContext = ODataRouterService.initializeModel(raml);
            return this;
        }
        catch (OdataMetadataFormatException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ApikitRuntimeException((Throwable)e);
        }
    }

    public Publisher<CoreEvent> process(CoreEvent event, AbstractRouter router) throws MuleException {
        logger.debug((Object)"Handling odata enabled request.");
        return this.process(event, arg_0 -> ((AbstractRouter)router).processEvent(arg_0));
    }

    private static OdataContext initializeModel(String ramlPath) throws OdataMetadataFormatException {
        OdataMetadataManagerImpl odataMetadataManager = new OdataMetadataManagerImpl(ramlPath);
        return new OdataContext(odataMetadataManager);
    }

    @Override
    protected OdataContext geODataContext() {
        return this.oDataContext;
    }
}

