/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.odata;

import java.util.List;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.odata.AbstractRouterInterface;
import org.mule.module.apikit.odata.ODataFormatHandler;
import org.mule.module.apikit.odata.ODataPayload;
import org.mule.module.apikit.odata.ODataResponseTransformer;
import org.mule.module.apikit.odata.ODataUriParser;
import org.mule.module.apikit.odata.context.OdataContext;
import org.mule.module.apikit.odata.error.ODataErrorHandler;
import org.mule.module.apikit.odata.formatter.ODataPayloadFormatter;
import org.mule.module.apikit.odata.processor.ODataRequestProcessor;
import org.mule.module.apikit.odata.util.CoreEventUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class AbstractODataRouterService {
    protected static final String ODATA_SVC_URI_PREFIX = "odata.svc";

    protected abstract OdataContext geODataContext();

    public Publisher<CoreEvent> process(CoreEvent event, AbstractRouterInterface router) throws MuleException {
        OdataContext oDataContext = this.geODataContext();
        HttpRequestAttributes attributes = CoreEventUtils.getHttpRequestAttributes(event);
        oDataContext.setMethod(attributes.getMethod());
        String path = attributes.getRelativePath();
        if (path.contains(ODATA_SVC_URI_PREFIX)) {
            return AbstractODataRouterService.processODataRequest(attributes, router, oDataContext, event);
        }
        return router.processEvent(event);
    }

    protected static Publisher<CoreEvent> processODataRequest(HttpRequestAttributes attributes, AbstractRouterInterface router, OdataContext oDataContext, CoreEvent event) throws MuleException {
        List<ODataPayloadFormatter.Format> formats = null;
        try {
            String listenerPath = attributes.getListenerPath().substring(0, attributes.getListenerPath().lastIndexOf("/*"));
            String path = attributes.getRelativePath().replaceAll(listenerPath, "");
            String query = attributes.getQueryString();
            ODataRequestProcessor odataRequestProcessor = ODataUriParser.parse(oDataContext, path, query);
            formats = ODataFormatHandler.getFormats(attributes);
            ODataPayload odataPayload = odataRequestProcessor.process(event, router, formats);
            Message message = ODataResponseTransformer.transform(odataPayload, formats);
            CoreEvent newEvent = CoreEvent.builder((CoreEvent)odataPayload.getMuleEvent()).message(message).addVariable("httpStatus", (Object)odataPayload.getStatus()).build();
            return Mono.just((Object)newEvent);
        }
        catch (Exception ex) {
            return Mono.just((Object)ODataErrorHandler.handle(event, ex, formats));
        }
    }

    static {
        System.setProperty("javax.ws.rs.ext.RuntimeDelegate", "org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl");
    }
}

