/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.model;

import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;

public class ValidationErrorsHandler {
    public static String handle(ProcessingReport report) {
        String msg = "";
        for (ProcessingMessage message : report) {
            String pointer = message.asJson().get("instance").get("pointer").toString().replace("\"", "");
            String keyword = message.asJson().get("keyword").toString().replace("\"", "");
            if (pointer.endsWith("/entity/name") && keyword.equals("minLength")) {
                msg = msg + "there are entities with empty names, please fix the model.";
                continue;
            }
            if (keyword.equals("oneOf")) {
                msg = msg + "some of the properties are invalid and cannot be matched against the schema.";
                continue;
            }
            msg = msg + message.getMessage();
        }
        if (msg.isEmpty()) {
            msg = "There are errors in the model, please validate it against the schema.";
        }
        return msg;
    }
}

