/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.mule.module.apikit.model.FileUtils;
import org.mule.module.apikit.model.RamlGenerator;
import org.mule.module.apikit.spi.ScaffolderService;
import org.mule.tools.apikit.Scaffolder;
import org.mule.tools.apikit.model.RuntimeEdition;

public class ODataScaffolderService
implements ScaffolderService {
    private static final List<String> appExtensions = Arrays.asList(".xml");
    private static final String LIBRARIES_FOLDER = "/libraries";
    private static final String LIBRARIES_ODATA_RAML = "/libraries/odataLibrary.raml";
    private static final String API_FOLDER = "api";
    private static final String ODATA_MODEL_FILE = "odata.raml";
    private static final String FINAL_RAML_FILE = "api.raml";

    public void executeScaffolder(List<File> ramlFiles, File appDir, File domainDir, String muleVersion, RuntimeEdition runtimeEdition) {
        Scaffolder scaffolder;
        List<String> domainFiles;
        List<String> ramlsWithExtensionEnabledPaths;
        List<String> ramlFilePaths = ramlsWithExtensionEnabledPaths = this.processDataModelFiles(ramlFiles);
        List<String> muleXmlFiles = this.retrieveFilePaths(appDir, appExtensions);
        SystemStreamLog log = new SystemStreamLog();
        String domain = null;
        if (domainDir != null && (domainFiles = this.retrieveFilePaths(domainDir, appExtensions)).size() > 0) {
            domain = domainFiles.get(0);
            if (domainFiles.size() > 1) {
                log.info((CharSequence)("There is more than one domain file inside of the domain folder. The domain: " + domain + " will be used."));
            }
        }
        try {
            scaffolder = Scaffolder.createScaffolder((Log)log, (File)appDir, ramlFilePaths, muleXmlFiles, domain, (String)muleVersion, (RuntimeEdition)runtimeEdition);
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing scaffolder", e);
        }
        scaffolder.run();
    }

    private List<String> retrieveFilePaths(File dir, List<String> extensions) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File " + dir.getName() + " must be a directory");
        }
        return this.retrieveFilePaths(new ArrayList<File>(Arrays.asList(dir.listFiles())), extensions);
    }

    private List<String> retrieveFilePaths(List<File> files, List<String> extensions) {
        ArrayList<String> filePaths = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                if (!this.containsValidExtension(file, extensions)) continue;
                filePaths.add(file.getAbsolutePath());
            }
        }
        return filePaths;
    }

    private boolean isODataModel(File file) {
        try {
            String path = file.getCanonicalPath();
            return path.contains(API_FOLDER + File.separator + ODATA_MODEL_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean containsValidExtension(File file, List<String> extensions) {
        for (String extension : extensions) {
            if (!file.getName().toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private List<String> processDataModelFiles(List<File> files) {
        ArrayList<String> ramlFilePaths = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                if (!this.isODataModel(file)) continue;
                this.copyRamlTemplateFiles(file);
                ramlFilePaths.add(this.generateApiRaml(file).getAbsolutePath());
            }
        }
        return ramlFilePaths;
    }

    private File generateApiRaml(File model) {
        RamlGenerator ramlGenerator = new RamlGenerator();
        File raml = null;
        try {
            String ramlContents = ramlGenerator.generate(model.toURI().toString());
            String path = model.getCanonicalPath().replace(ODATA_MODEL_FILE, FINAL_RAML_FILE);
            raml = FileUtils.stringToFile(path, ramlContents);
        }
        catch (Exception e) {
            SystemStreamLog log = new SystemStreamLog();
            log.error((CharSequence)("Error: " + e.getMessage()));
            throw new RuntimeException("Error: " + e.getMessage());
        }
        return raml;
    }

    private List<String> copyRamlTemplateFiles(File model) {
        ArrayList<String> ramlFiles = new ArrayList<String>();
        try {
            FileUtils.createFolder(model.getParentFile().getAbsolutePath() + LIBRARIES_FOLDER);
            ramlFiles.add(FileUtils.exportResource(LIBRARIES_ODATA_RAML, model.getParentFile().getAbsolutePath() + LIBRARIES_ODATA_RAML));
        }
        catch (Exception e) {
            throw new RuntimeException("Error copying template files", e);
        }
        return ramlFiles;
    }
}

