/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static String readFromFile(String filePath) throws FileNotFoundException, IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(filePath);
        File file = new File(url.getPath());
        FileInputStream is = new FileInputStream(file);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer);
        ((InputStream)is).close();
        return writer.toString();
    }

    public static String readFromFile(InputStream input) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)input, (Writer)writer);
        input.close();
        return writer.toString();
    }

    public static File stringToFile(String path, String body) throws IOException {
        File file = new File(path);
        try (FileOutputStream fop = new FileOutputStream(file);){
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] contentInBytes = body.getBytes();
            fop.write(contentInBytes);
            fop.flush();
            fop.close();
        }
        return file;
    }

    public static String exportResource(String resourceName, String targetPath) throws Exception {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = FileUtils.class.getResource(resourceName).openStream();
            out = new FileOutputStream(targetPath);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            in.close();
            out.close();
        }
        return targetPath;
    }

    public static boolean createFolder(String path) {
        return new File(path).mkdir();
    }
}

