/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.mule.module.apikit.model.AMFWrapper;
import org.mule.module.apikit.model.Entity;
import org.mule.module.apikit.model.Property;
import org.mule.module.apikit.model.exception.EntityModelParsingException;
import org.mule.module.apikit.model.exception.InvalidModelException;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinition;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionProperty;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionSet;

public class EntityModelParser {
    static final String typesPattern = "^types:\\s*$";
    static final Pattern elementPattern = Pattern.compile("^\\s{2}(\\w+):\\s*$");
    static final Pattern remotePattern = Pattern.compile("^\\s{4}\\(odata.remote\\):\\s*(\\w+)\\s*$");
    static final String propertiesPattern = "^\\s{4}properties:\\s*$";
    static final Pattern fieldPattern = Pattern.compile("^\\s{6}(\\w+):\\s*$");
    static final Pattern typePropertyPattern = Pattern.compile("^\\s{8}type:\\s*(\\w+)\\s*$");
    static final Pattern keyPropertyPattern = Pattern.compile("^\\s{8}\\(odata.key\\):\\s*(\\w+)\\s*$");
    static final Pattern nullablePropertyPattern = Pattern.compile("^\\s{8}\\(odata.nullable\\):\\s*(\\w+)\\s*$");

    public static List<Entity> getEntities(String pathToModel) throws IOException, EntityModelParsingException {
        try {
            AMFWrapper amfWrapper = new AMFWrapper(pathToModel);
            return EntityModelParser.getEntities(amfWrapper.getSchemas());
        }
        catch (Exception e) {
            throw new EntityModelParsingException(e.getMessage());
        }
    }

    private static List<Entity> getEntities(EntityDefinitionSet entityDefinitionSet) throws InvalidModelException {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        boolean typesFound = false;
        for (EntityDefinition entityDefinition : entityDefinitionSet.toList()) {
            typesFound = true;
            Entity entity = new Entity(entityDefinition.getName());
            entity.setRemote(entityDefinition.getRemoteEntity());
            entity.setPropertiesFound(true);
            for (EntityDefinitionProperty entityDefinitionProperty : entityDefinition.getProperties()) {
                Property property = new Property(entityDefinitionProperty.getName());
                property.setKey(String.valueOf(entityDefinitionProperty.isKey()));
                property.setNullable(String.valueOf(entityDefinitionProperty.isNullable()));
                property.setType(entityDefinitionProperty.getType());
                entity.addProperty(property);
            }
            entities.add(entity);
        }
        if (!typesFound) {
            throw new InvalidModelException("no types definition where found, please check the model");
        }
        return entities;
    }

    public static String getSchemaTypeFromEdmType(String edmType) {
        String schemaType = "string";
        switch (edmType) {
            case "Edm.Boolean": {
                schemaType = "boolean";
                break;
            }
            case "Edm.Decimal": 
            case "Edm.Double": 
            case "Edm.Single": {
                schemaType = "number";
                break;
            }
            case "Edm.Int16": 
            case "Edm.Int32": 
            case "Edm.Int64": 
            case "Edm.SByte": {
                schemaType = "integer";
                break;
            }
            case "Edm.Guid": 
            case "Edm.Binary": 
            case "Edm.DateTime": 
            case "Edm.String": 
            case "Edm.Time": 
            case "Edm.DateTimeOffset": {
                schemaType = "string";
            }
        }
        return schemaType;
    }
}

