/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.model;

import amf.ProfileNames;
import amf.client.AMF;
import amf.client.model.document.BaseUnit;
import amf.client.model.document.Document;
import amf.client.model.document.Module;
import amf.client.model.domain.DomainElement;
import amf.client.model.domain.DomainExtension;
import amf.client.model.domain.FileShape;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.PropertyShape;
import amf.client.model.domain.ScalarNode;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.Shape;
import amf.client.model.domain.UnionShape;
import amf.client.parse.Raml10Parser;
import amf.client.validate.ValidationReport;
import amf.client.validate.ValidationResult;
import amf.plugins.features.validation.AMFValidatorPlugin;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFieldsException;
import org.mule.module.apikit.odata.metadata.exception.OdataMetadataFormatException;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinition;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionProperty;
import org.mule.module.apikit.odata.metadata.model.entities.EntityDefinitionSet;
import org.mule.module.apikit.odata.metadata.raml.RamlParser;

public class AMFWrapper {
    public static final String AMF_STRING = "http://www.w3.org/2001/XMLSchema#string";
    public static final String AMF_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    public static final String AMF_NUMBER = "http://a.ml/vocabularies/shapes#number";
    public static final String AMF_FLOAT = "http://www.w3.org/2001/XMLSchema#float";
    public static final String AMF_DATE_TIME_ONLY = "http://a.ml/vocabularies/shapes#dateTimeOnly";
    public static final String AMF_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    public static final String AMF_TIME = "http://www.w3.org/2001/XMLSchema#time";
    public static final String AMF_DATE_TIME = "http://www.w3.org/2001/XMLSchema#dateTime";
    public static final String AMF_DATE_ONLY = "http://www.w3.org/2001/XMLSchema#date";
    public static final String AMF_LONG = "http://www.w3.org/2001/XMLSchema#long";
    private List<NodeShape> nodeShapesList;
    private Map<String, NodeShape> shapes = new HashMap<String, NodeShape>();
    private EntityDefinitionSet entityDefinitionSet = new EntityDefinitionSet();

    public AMFWrapper(String ramlPath) throws OdataMetadataFormatException, OdataMetadataFieldsException {
        try {
            this.initNodeShapesList(ramlPath);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new OdataMetadataFormatException("RAML is invalid. See log list.");
        }
        for (NodeShape nodeShape : this.nodeShapesList) {
            this.shapes.put(nodeShape.name().value(), nodeShape);
            this.entityDefinitionSet.addEntity(this.buildEntityDefinition(nodeShape));
        }
    }

    private void validateOdataRaml(Raml10Parser parser) throws InterruptedException, ExecutionException, OdataMetadataFieldsException {
        List validationResults = ((ValidationReport)parser.reportValidation(ProfileNames.RAML()).get()).results();
        if (validationResults.isEmpty()) {
            return;
        }
        String errorMessage = "Parse of odata.raml file failed: ";
        for (ValidationResult validationResult : validationResults) {
            errorMessage = errorMessage.concat(validationResult.message() + "\n");
        }
        throw new OdataMetadataFieldsException(errorMessage);
    }

    private void initNodeShapesList(String ramlPath) throws ExecutionException, InterruptedException, OdataMetadataFieldsException, OdataMetadataFormatException {
        this.nodeShapesList = new ArrayList<NodeShape>();
        Raml10Parser parser = AMF.raml10Parser();
        Object object = parser.parseFileAsync(ramlPath).get();
        this.validateOdataRaml(parser);
        if (object instanceof Module) {
            this.addNodeShapes((Module)object, true);
        } else if (object instanceof Document) {
            Document document = (Document)object;
            for (BaseUnit baseUnit : document.references()) {
                if (!(baseUnit instanceof Module)) continue;
                this.addNodeShapes((Module)baseUnit, false);
            }
        }
        if (this.nodeShapesList.isEmpty()) {
            throw new OdataMetadataFieldsException("odata.raml must declare at least one type");
        }
    }

    private void addNodeShapes(Module module, boolean throwException) throws OdataMetadataFormatException, OdataMetadataFieldsException {
        for (DomainElement domainElement : module.declares()) {
            if (!(domainElement instanceof Shape)) continue;
            String remoteName = this.getAnnotation((Shape)domainElement, RamlParser.NAMESPACE_REMOTE_NAME);
            if (domainElement instanceof NodeShape) {
                NodeShape nodeShape = (NodeShape)domainElement;
                if (remoteName != null) {
                    this.nodeShapesList.add(nodeShape);
                    continue;
                }
                if (!throwException) continue;
                throw new OdataMetadataFieldsException("Property \"remote name\" is missing in entity " + nodeShape.name());
            }
            if (remoteName == null) continue;
            throw new OdataMetadataFormatException("Type not supported. " + remoteName);
        }
    }

    public EntityDefinitionSet getSchemas() {
        return this.entityDefinitionSet;
    }

    private EntityDefinition buildEntityDefinition(NodeShape nodeShape) throws OdataMetadataFormatException, OdataMetadataFieldsException {
        if (nodeShape.properties().isEmpty()) {
            throw new OdataMetadataFormatException("No schemas found.");
        }
        String entityName = nodeShape.name().value();
        String remoteName = this.getAnnotation((Shape)nodeShape, RamlParser.NAMESPACE_REMOTE_NAME);
        EntityDefinition entityDefinition = new EntityDefinition(entityName, remoteName);
        for (PropertyShape propertyShape : nodeShape.properties()) {
            String defaultValue;
            Shape shape = this.getScalarShape(propertyShape.range());
            String propertyName = propertyShape.name().value();
            this.notNull("Property \"name\" is missing in field \"" + propertyName + "\" in entity \"" + entityName + "\"", entityName);
            this.notNull("Property \"remote name\" is missing in field \"" + propertyName + "\" in entity \"" + entityName + "\"", remoteName);
            EntityDefinitionProperty entityDefinitionProperty = null;
            String key = this.getAnnotation(shape, RamlParser.NAMESPACE_KEY_PROPERTY);
            this.notNull("Property \"key\" is missing in field \"" + propertyName + "\" in entity \"" + entityName + "\"", key);
            boolean isKey = Boolean.valueOf(key);
            String nullable = this.getAnnotation(shape, RamlParser.NAMESPACE_NULLABLE_PROPERTY);
            this.notNull("Property \"nullable\" is missing in field \"" + propertyName + "\" in entity \"" + entityName + "\"", nullable);
            boolean isNullable = Boolean.valueOf(nullable);
            String string = defaultValue = propertyShape.defaultValue() != null ? propertyShape.defaultValue().name().value() : null;
            if (shape instanceof ScalarShape) {
                ScalarShape scalarShape = (ScalarShape)shape;
                String type = this.getOdataType(scalarShape);
                this.notNull("Property \"type\" is missing in field \"" + propertyName + "\" in entity \"" + entityName + "\"", type);
                String maxLength = null;
                if ("Edm.String".equals(type)) {
                    Integer maxLengthInt = scalarShape.maxLength().value();
                    maxLength = maxLengthInt != 0 ? String.valueOf(maxLengthInt) : null;
                }
                String precision = this.getAnnotation((Shape)scalarShape, RamlParser.NAMESPACE_PRECISION_PROPERTY);
                String scale = this.getAnnotation((Shape)scalarShape, RamlParser.NAMESPACE_SCALE_PROPERTY);
                entityDefinitionProperty = new EntityDefinitionProperty(propertyName, type, isNullable, isKey, defaultValue, maxLength, false, null, false, precision, scale);
            } else if (shape instanceof FileShape) {
                entityDefinitionProperty = new EntityDefinitionProperty(propertyName, "Edm.Binary", isNullable, isKey, defaultValue, null, false, null, false, null, null);
            } else {
                throw new OdataMetadataFieldsException("Type not supported of property " + propertyName);
            }
            entityDefinition.addProperty(entityDefinitionProperty);
            if (entityDefinition.hasPrimaryKey() || !entityDefinitionProperty.isKey()) continue;
            entityDefinition.setHasPrimaryKey(true);
        }
        if (!entityDefinition.hasPrimaryKey()) {
            throw new OdataMetadataFieldsException("Entity defition must have a primary key.");
        }
        return entityDefinition;
    }

    private String getOdataType(ScalarShape scalarShape) throws OdataMetadataFieldsException {
        String dataType = scalarShape.dataType().value();
        if (dataType.equals(AMF_BOOLEAN)) {
            return "Edm.Boolean";
        }
        if (dataType.equals(AMF_STRING)) {
            return this.getStringType(scalarShape);
        }
        if (dataType.equals(AMF_FLOAT)) {
            return "Edm.Single";
        }
        if (dataType.equals(AMF_DATE_TIME_ONLY)) {
            return "Edm.DateTime";
        }
        if (dataType.equals(AMF_NUMBER) || dataType.equals(AMF_INTEGER) || dataType.equals(AMF_LONG)) {
            return this.getNumberType(scalarShape);
        }
        if (dataType.equals(AMF_TIME)) {
            return "Edm.Time";
        }
        if (dataType.equals(AMF_DATE_TIME)) {
            return "Edm.DateTime";
        }
        if (dataType.equals(AMF_DATE_ONLY)) {
            return "Edm.DateTimeOffset";
        }
        throw new UnsupportedOperationException("Type not supported " + dataType + " of property " + scalarShape.name());
    }

    private Shape getScalarShape(Shape shape) throws OdataMetadataFieldsException {
        if (shape instanceof UnionShape) {
            UnionShape unionShape = (UnionShape)shape;
            List annotations = shape.customDomainProperties();
            for (Shape unionSubShape : unionShape.anyOf()) {
                if (!(unionSubShape instanceof ScalarShape)) continue;
                unionSubShape.withCustomDomainProperties(annotations);
                return unionSubShape;
            }
            throw new OdataMetadataFieldsException(String.format("Property %s cannot be just null.", shape.name()));
        }
        return shape;
    }

    private String getNumberType(ScalarShape scalarShape) throws OdataMetadataFieldsException {
        String format = scalarShape.format().value();
        if (format != null) {
            switch (format) {
                case "int64": {
                    return "Edm.Int64";
                }
                case "int32": {
                    return "Edm.Int32";
                }
                case "int16": {
                    return "Edm.Int16";
                }
                case "int8": {
                    return "Edm.Byte";
                }
            }
            throw new OdataMetadataFieldsException(String.format("Unexpected format %s for number type.", format));
        }
        if (scalarShape.dataType().value().equals(AMF_INTEGER)) {
            return "Edm.Int32";
        }
        String scale = this.getAnnotation((Shape)scalarShape, RamlParser.NAMESPACE_SCALE_PROPERTY);
        String precision = this.getAnnotation((Shape)scalarShape, RamlParser.NAMESPACE_PRECISION_PROPERTY);
        if (scale != null && precision != null) {
            return "Edm.Decimal";
        }
        return "Edm.Double";
    }

    private String getStringType(ScalarShape scalarShape) {
        String subType = this.getAnnotation((Shape)scalarShape, RamlParser.NAMESPACE_TYPE_PROPERTY);
        if ("guid".equals(subType)) {
            return "Edm.Guid";
        }
        return "Edm.String";
    }

    private void notNull(String message, Object actual) throws OdataMetadataFieldsException {
        if (actual == null || Strings.isNullOrEmpty((String)actual.toString())) {
            throw new OdataMetadataFieldsException(message);
        }
    }

    @Nullable
    private String getAnnotation(Shape nodeShape, String annotationName) {
        for (DomainExtension annotation : nodeShape.customDomainProperties()) {
            if (!annotationName.equals(annotation.name().value())) continue;
            return ((ScalarNode)annotation.extension()).value();
        }
        return null;
    }

    static {
        try {
            AMF.init().get();
            AMFValidatorPlugin.withEnabledValidation((boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

