/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.endpoint;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.mule.api.transport.Connector;
import org.mule.config.annotations.endpoints.ChannelType;
import org.mule.impl.endpoint.MEP;

public class AnnotatedEndpointData {
    private boolean synchronous = false;
    private String encoding;
    private Map properties = new HashMap();
    private String connectorName;
    private String transformers;
    private String address;
    private String name;
    private String filter;
    private String correlationExpression;
    private Connector connector;
    private MEP mep;
    private ChannelType type;
    private Annotation annotation;

    public AnnotatedEndpointData(MEP mep, Annotation annotation) {
        this.mep = mep;
        this.annotation = annotation;
        ChannelType channelType = this.type = mep == MEP.InOnly || mep == MEP.InOptionalOut || mep == MEP.InOut ? ChannelType.Inbound : ChannelType.Outbound;
        this.synchronous = this.type == ChannelType.Inbound ? !mep.equals((Object)MEP.InOnly) : !mep.equals((Object)MEP.OutOnly);
    }

    protected String emptyToNull(String value) {
        return "".equals(value) ? null : value;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getAddress() {
        return this.address;
    }

    public Map getProperties() {
        return this.properties;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public ChannelType getType() {
        return this.type;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getCorrelationExpression() {
        return this.correlationExpression;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public String getTransformers() {
        return this.transformers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = this.emptyToNull(name);
    }

    public void setEncoding(String encoding) {
        this.encoding = this.emptyToNull(encoding);
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setProperties(Map properties) {
        if (properties == null) {
            return;
        }
        this.properties = properties;
        if (properties != null && properties.containsKey("connectorName")) {
            this.setConnectorName((String)properties.remove("connectorName"));
        }
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = this.emptyToNull(connectorName);
    }

    public void setTransformers(String transformers) {
        this.transformers = this.emptyToNull(transformers);
    }

    public void setAddress(String address) {
        this.address = this.emptyToNull(address);
    }

    public void setFilter(String filter) {
        this.filter = this.emptyToNull(filter);
    }

    public void setCorrelationExpression(String correlationExpression) {
        this.correlationExpression = this.emptyToNull(correlationExpression);
    }

    public MEP getMep() {
        return this.mep;
    }

    public void setMEPUsingMethod(Method method, boolean inbound) {
        this.mep = method.getReturnType().equals(Void.TYPE) ? (inbound ? MEP.InOnly : MEP.OutOnly) : (inbound ? MEP.InOut : MEP.OutIn);
    }

    public static Map convert(String[] properties) {
        if (properties.length > 0) {
            Properties props = new Properties();
            for (int i = 0; i < properties.length; ++i) {
                String property = properties[i];
                if (property.length() == 0) continue;
                int x = property.indexOf("=");
                if (x < 1) {
                    throw new IllegalArgumentException("Property string is malformed: " + property);
                }
                String value = property.substring(x + 1);
                property = property.substring(0, x);
                props.setProperty(property, value);
            }
            return props;
        }
        return null;
    }
}

