/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.annotations.converters;

import java.util.Properties;
import java.util.StringTokenizer;
import org.mule.api.MuleContext;
import org.mule.api.expression.PropertyConverter;
import org.mule.util.StringUtils;

public class PropertiesConverter
implements PropertyConverter {
    public static final String DELIM = ",";

    public Object convert(String properties, MuleContext context) {
        if (StringUtils.isNotBlank((String)properties)) {
            Properties props = new Properties();
            StringTokenizer st = new StringTokenizer(properties, DELIM);
            while (st.hasMoreTokens()) {
                String key = st.nextToken().trim();
                int i = key.indexOf("=");
                if (i < 1) {
                    throw new IllegalArgumentException("Property string is malformed: " + properties);
                }
                String value = key.substring(i + 1);
                key = key.substring(0, i);
                props.setProperty(key, value);
            }
            return props;
        }
        return null;
    }

    public Class getType() {
        return Properties.class;
    }
}

