/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.annotations.processors;

import java.lang.reflect.Field;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.registry.ObjectProcessor;

public class InjectAnnotationProcessor
implements ObjectProcessor,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(InjectAnnotationProcessor.class);
    private MuleContext context;

    public InjectAnnotationProcessor() {
    }

    public InjectAnnotationProcessor(MuleContext context) {
        this.context = context;
    }

    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    public Object process(Object object) {
        Field[] fields;
        try {
            fields = object.getClass().getDeclaredFields();
        }
        catch (NoClassDefFoundError e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)e.toString());
            }
            return object;
        }
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.isAnnotationPresent(Inject.class)) continue;
            try {
                field.setAccessible(true);
                Object value = this.context.getRegistry().lookupObject(field.getType());
                if (value == null) {
                    throw new RuntimeException("Required object not found in registry of Type: " + field.getType());
                }
                field.set(object, value);
                continue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return object;
    }
}

