/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.util.RegexECMA262Helper;

public final class ObjectSchemaSelector {
    private static final JsonPointer PROPERTIES = JsonPointer.of("properties", new Object[0]);
    private static final JsonPointer PATTERNPROPERTIES = JsonPointer.of("patternProperties", new Object[0]);
    private static final JsonPointer ADDITIONALPROPERTIES = JsonPointer.of("additionalProperties", new Object[0]);
    private final List<String> properties;
    private final List<String> patternProperties;
    private final boolean hasAdditional;

    public ObjectSchemaSelector(JsonNode digest) {
        this.hasAdditional = digest.get("hasAdditional").booleanValue();
        ArrayList list = Lists.newArrayList();
        for (JsonNode node : digest.get("properties")) {
            list.add(node.textValue());
        }
        this.properties = ImmutableList.copyOf((Collection)list);
        list = Lists.newArrayList();
        for (JsonNode node : digest.get("patternProperties")) {
            list.add(node.textValue());
        }
        this.patternProperties = ImmutableList.copyOf((Collection)list);
    }

    public Iterable<JsonPointer> selectSchemas(String memberName) {
        ArrayList list = Lists.newArrayList();
        if (this.properties.contains(memberName)) {
            list.add(PROPERTIES.append(memberName));
        }
        for (String regex : this.patternProperties) {
            if (!RegexECMA262Helper.regMatch(regex, memberName)) continue;
            list.add(PATTERNPROPERTIES.append(regex));
        }
        if (!list.isEmpty()) {
            return ImmutableList.copyOf((Collection)list);
        }
        return this.hasAdditional ? ImmutableList.of((Object)ADDITIONALPROPERTIES) : Collections.emptyList();
    }
}

