/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.NodeType;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.cfg.ValidationConfiguration;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.Processor;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.util.Dictionary;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.FormatAttribute;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.library.Library;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.messages.JsonSchemaValidationBundle;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.SchemaContext;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.ValidatorList;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.load.MessageBundles;

public final class FormatProcessor
implements Processor<ValidatorList, ValidatorList> {
    private final Map<String, FormatAttribute> attributes;
    private final MessageBundle bundle;

    public FormatProcessor(Library library, ValidationConfiguration cfg) {
        this.attributes = library.getFormatAttributes().entries();
        this.bundle = cfg.getValidationMessages();
    }

    @VisibleForTesting
    FormatProcessor(Dictionary<FormatAttribute> dict) {
        this.attributes = dict.entries();
        this.bundle = MessageBundles.getBundle(JsonSchemaValidationBundle.class);
    }

    @Override
    public ValidatorList process(ProcessingReport report, ValidatorList input) throws ProcessingException {
        SchemaContext context = input.getContext();
        JsonNode node = context.getSchema().getNode().get("format");
        if (node == null) {
            return input;
        }
        String fmt = node.textValue();
        FormatAttribute attr = this.attributes.get(fmt);
        if (attr == null) {
            report.warn(input.newMessage().put("domain", "validation").put("keyword", "format").setMessage(this.bundle.getMessage("warn.format.notSupported")).putArgument("attribute", fmt));
            return input;
        }
        NodeType type = context.getInstanceType();
        if (!attr.supportedTypes().contains((Object)type)) {
            return input;
        }
        ArrayList validators = Lists.newArrayList((Iterable)input);
        validators.add(FormatProcessor.formatValidator(attr));
        return new ValidatorList(context, validators);
    }

    private static KeywordValidator formatValidator(final FormatAttribute attr) {
        return new KeywordValidator(){

            @Override
            public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
                attr.validate(report, bundle, data);
            }
        };
    }

    public String toString() {
        return "format attribute handler";
    }
}

