/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.extra;

import java.util.UUID;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.NodeType;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.AbstractFormatAttribute;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.FormatAttribute;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class UUIDFormatAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute instance = new UUIDFormatAttribute();

    private UUIDFormatAttribute() {
        super("uuid", NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return instance;
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        try {
            UUID.fromString(input);
        }
        catch (IllegalArgumentException ignored) {
            report.error(this.newMsg(data, bundle, "err.format.UUID.invalid").putArgument("value", input));
        }
    }
}

