/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.cleanup;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.JsonNodeReader;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.load.MessageBundles;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.provider.LoadingMessageSourceProvider;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.provider.MessageSourceProvider;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonModuleResourceReleaser {
    private static final String BUNDLE = "BUNDLE";
    private static final String BUNDLES = "BUNDLES";
    private static final String PROVIDERS = "providers";
    private static final String SERVICE = "service";
    private static final String POOL = "pool";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonModuleResourceReleaser.class);
    SchedulerService schedulerService;

    public JsonModuleResourceReleaser(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public synchronized void releaseExecutors() {
        MessageBundle messageBundle;
        Field bundleField;
        LOGGER.debug("Stopping the known executors services");
        try {
            bundleField = JsonNodeReader.class.getDeclaredField(BUNDLE);
            messageBundle = (MessageBundle)bundleField.get(null);
            this.cleanMessageBundle(messageBundle);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service reference of the JsonNodeReader class: {}", (Object)ex.getMessage(), (Object)ex);
        }
        try {
            bundleField = MessageBundles.class.getDeclaredField(BUNDLES);
            Map bundles = (Map)bundleField.get(null);
            for (MessageBundle bundle : bundles.values()) {
                this.cleanMessageBundle(bundle);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service references of the MessageBundles class: {}", (Object)ex.getMessage(), (Object)ex);
        }
        try {
            bundleField = ProcessingMessage.class.getDeclaredField(BUNDLE);
            messageBundle = (MessageBundle)bundleField.get(null);
            this.cleanMessageBundle(messageBundle);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service references of the ProcessingMessage class: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void cleanMessageBundle(MessageBundle bundle) throws NoSuchFieldException, IllegalAccessException {
        Field providersField = MessageBundle.class.getDeclaredField(PROVIDERS);
        List messageSourceProviders = (List)providersField.get(bundle);
        for (MessageSourceProvider provider : messageSourceProviders) {
            if (!(provider instanceof LoadingMessageSourceProvider)) continue;
            Field serviceField = LoadingMessageSourceProvider.class.getDeclaredField(SERVICE);
            ExecutorService service = (ExecutorService)serviceField.get(provider);
            service.shutdown();
            try {
                service.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException exception) {
                service.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void restoreExecutorServices() {
        MessageBundle messageBundle;
        Field bundleField;
        try {
            bundleField = JsonNodeReader.class.getDeclaredField(BUNDLE);
            messageBundle = (MessageBundle)bundleField.get(null);
            this.restoreMessageBundle(messageBundle);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service reference of the JsonNodeReader class: {}", (Object)ex.getMessage(), (Object)ex);
        }
        try {
            bundleField = MessageBundles.class.getDeclaredField(BUNDLES);
            Map bundles = (Map)bundleField.get(null);
            for (MessageBundle bundle : bundles.values()) {
                this.restoreMessageBundle(bundle);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service references of the MessageBundles class: {}", (Object)ex.getMessage(), (Object)ex);
        }
        try {
            bundleField = ProcessingMessage.class.getDeclaredField(BUNDLE);
            messageBundle = (MessageBundle)bundleField.get(null);
            this.restoreMessageBundle(messageBundle);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service references of the ProcessingMessage class: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void restoreMessageBundle(MessageBundle bundle) throws NoSuchFieldException, IllegalAccessException {
        Field providersField = MessageBundle.class.getDeclaredField(PROVIDERS);
        List messageSourceProviders = (List)providersField.get(bundle);
        for (MessageSourceProvider provider : messageSourceProviders) {
            Field serviceField;
            ExecutorService service;
            if (!(provider instanceof LoadingMessageSourceProvider) || !(service = (ExecutorService)(serviceField = LoadingMessageSourceProvider.class.getDeclaredField(SERVICE)).get(provider)).isShutdown()) continue;
            service = this.schedulerService.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(3).withPrefix(POOL));
            serviceField.set(provider, service);
        }
    }
}

